function [cost,grad]=costgrad_ICA(W,X,op)

if(nargin~=3)
    error('Check the number of arguments.\n');
end

if(size(W,2)<2)
    W=reshape(W,[op.components,size(X,1)]);
end

% sample number
N=size(X,2);

% coeffcients
S = W*X;

% gradient 
grad = tanh(S)*X'/N-inv(W');
grad = grad(:);

% cost
cost = mean(sum(log(cosh((S)))))-log(abs(det(W)));