function [Wnew,J]=estimation(W,X,H,op)
J=0;
if(op.ica==1)
    fprintf('Estimation of W.\n');
    
    f1='costgrad_ICA';
    W=W(:);
    [W,~,~]=minimize(W, f1, op.length, X, op);
    W=reshape(W,[op.components,size(X,1)]);
   
    fprintf('\n');
end

if(op.ordersign==1)
    fprintf('Optimization of ordering and signs.\n');

    % Preserving W before optimization.
    Wb=W;    
    % Initilizing W to be optimized.
    Wo=Wb;
    
    % Remaining indice.
    rindice=(2:op.components)';
    
    for yy=1:op.ydim
        dir='horizontal';
        [Wo, rindice]=ReorderingResignning(Wb,Wo,X,H,rindice,yy,op,dir);

        if(yy==op.ydim)
            break;
        end
        
        dir='vertical';
        [Wo, rindice]=ReorderingResignning(Wb,Wo,X,H,rindice,yy,op,dir);
    end
    
    W=Wo;
    
    fprintf('\n');
end

if(op.est==1)
    fprintf('Re-estimation of W.\n');

    f=['costgrad_' op.f];
    W=W(:);
    [W,~,~]=minimize(W,f,op.length,X,H,op);
    W=reshape(W,[op.components,size(X,1)]);    

    J=feval(f,W,X,H,op);
    fprintf('\n');
end

Wnew=W;