function Snei=extract_neigboring(So,ind,H)
% Extracting components around one component at a location ind. 
% So  : S partially optimized
% ind : index of S
% H   : topographic matrix

if(nargin~=3)
    narginerror;
end

smallH=zeros(size(H,3),size(H,2));

for ii=1:size(H,3)
    H(:,:,ii)=abs(H(:,:,ii)-eye(size(H,1)));
    
    smallH(ii,:)=H(ind,:,ii);
end

Snei=smallH*So;