function IndofUInd=find_usedindice(minindice,ii,jj,model)

% Find already used indice to avoid overlapping selections of indices.
% IndofUInd : indice of already used indice.
% In the case where IndofUInd conitans inf, suppose that all of IndofUInd are inf.

if(nargin~=4)
    narginerror();
end

IndofUInd=zeros(ii-1,1);

if(strcmp(model,'TICA')~=1)
    Ni=round(size(minindice,2)/2);
else
    Ni=size(minindice,2);
end

for kk=ii:-1:2
    if(kk==ii)
        IndofUInd(kk-1)=minindice(kk,jj);
    else
        if(isinf(IndofUInd(kk))~=1)
            IndofUInd(kk-1)=minindice(kk,IndofUInd(kk));
        else
            IndofUInd=inf;
            break;
        end
    end
end

if(strcmp(model,'TICA')~=1)
    IndofUInd(Ni<IndofUInd)=IndofUInd(Ni<IndofUInd)-Ni;
end

IndofUInd=unique(IndofUInd);