function adjS=make_adjacentS(S,jj,rindice,indiceofusedindice,model)

% Inserting infinity on jj and used indice to avoid overlapping indice.

if(nargin~=5)
    narginerror;
end
    
Ni=length(rindice);

% Current remaining components
tmpS=S(rindice,:);

% Inserting infinity at jj index.
if(strcmp(model,'TICA')==1)    
    tmpS(jj,:)=inf;
else
    tmpS=repmat(tmpS,[2,1]);
    tmpS(Ni+1:end,:)=-tmpS(Ni+1:end,:);
    
    if(Ni<jj)
        tmpS(jj,:)=inf; tmpS(jj-Ni,:)=inf;
    else
        tmpS(jj,:)=inf; tmpS(jj+Ni,:)=inf;
    end
end

% Inserting infinity at used indice.
if(~isempty(indiceofusedindice))
    tmpS(indiceofusedindice,:)=inf;
    if(strcmp(model,'TICA')~=1)
        tmpS(indiceofusedindice+Ni,:)=inf;
    end
end

adjS=tmpS;