function X=data(samples, winsize)

% a total number of images
dataNum = 13;

% number of patches per image
getsample = floor(samples/dataNum);

%Initialize the matrix to hold the patches
X = zeros(winsize^2, getsample*dataNum);

sampleNum = 1;
for i=1:dataNum
    % even things up
    if i==dataNum, getsample = samples-sampleNum+1; end
    
    %Load the image
    I = imread(['../../data/' num2str(i) '.tiff']);
    
    %Normalize to zero mean and unit variance
    I = double(I);
    I = I-mean(mean(I)); %mean
    I = I/sqrt(mean(mean(I.^2))); %variance
    
    %Sample
    fprintf('Sample image %d...\n', i);
    sizex = size(I,2); sizey = size(I,1);
    posx = floor(rand(1,getsample)*(sizex-winsize-1))+1;
    posy = floor(rand(1,getsample)*(sizey-winsize-1))+1;
    
    for j=1:getsample
        X(:,sampleNum) = reshape(I(posy(1,j):posy(1,j)+winsize-1, ...
            posx(1,j):posx(1,j)+winsize-1),[winsize^2 1]);
        sampleNum = sampleNum+1;
    end
end