clear all;

addpath('../');

samples=30000;
winsize=8;
rdim=40;

op.components=rdim;
op.xdim=8;
op.ydim=5;
op.lambda=1.0;
op.toponum=8;

op.length=5000;
op.ica=1;
op.ordersign=1;
op.est=1;
op.f='CTA';

parametererror(op);

H=topographyMatrix(op);

% gathering data.
X=data(samples,winsize);
% removing DC components;
X=removeDC(X);
% whitening
[X,whiteningMatrix, dewhiteningMatrix] = whitening(X,rdim);

rng('shuffle');
Winit=randn(op.components,rdim);

[W,J]=estimation(Winit,X,H,op);

fname=['../../result/natural_image/' op.f 'toponum'...
    num2str(op.toponum) '.mat'];
save(fname,'W','whiteningMatrix','dewhiteningMatrix','op','J');

fname=['../../result/natural_image/' op.f 'toponum'...
    num2str(op.toponum) 'data.mat'];
save(fname,'X');
