function newminvalue=optonecomponent(Sb,So,rindice,op,model,H,dir)

if(nargin~=7)
    narginerror;
end

Ni=length(rindice);
Nc=set_numberofcombinations(rindice,model);

newminvalue=zeros(1,Nc);

tmpS=repmat(Sb(rindice,:),[2,1]);
tmpS(Ni+1:end,:)=-tmpS(Ni+1:end,:);

if(strcmp(dir,'horizontal')==1)
    ind=(op.ydim-1)*op.xdim+op.xdim;
    Snei=extract_neigboring(So,ind,H);

    % sum of all components
    for ii=1:op.toponum
        newminvalue=newminvalue...
            +compute_comb(repmat(Snei(ii,:),[Nc,1]),tmpS,model);
    end
elseif(strcmp(dir,'vertical')==1)
    ind=(op.ydim-1)*op.xdim+op.ydim-1;
    Snei=extract_neigboring(So,ind,H);
    
    htoponum=round(op.toponum/2);

    % sum of all components except for left components
    for ii=1:op.toponum
        if(ii~=htoponum+1)
            newminvalue=newminvalue...
                +compute_comb(repmat(Snei(ii,:),[Nc,1]),tmpS,model);
        end
    end
end