function H=topographyMatrix(op)
%
% Creating topography matrix. 
% 
% H: topographiy matrix (size: [op.components, op.components, ind])
% H(:,:,ind) specifies topographic relationship as denoted in the
% following
% 
% toponum : number of topographic components. insert 2, 4 or 8. 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%% topography relation on 1D lattice %%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%% 1     2 %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%% topography relation on 2D lattice %%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%    1    %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%% 2     3 %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%    4    %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%% topography relation on 2D lattice %%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%% 1  2  3 %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%% 4     5 %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%% 6  7  8 %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

H=zeros(op.components,op.components,op.toponum);

for ii=1:op.toponum
    if(op.toponum==2)
        yy=1:op.ydim;

        if(ii==1)
            xx=1:op.xdim-1; xx=[op.xdim xx];
        else
            xx=2:op.xdim; xx=[xx 1];
        end            
    elseif(op.toponum==8)
        if((1<=ii)&&(ii<=3))
            yy=1:op.ydim-1; yy=[op.ydim yy];

            if(ii==1)
                xx=1:op.xdim-1; xx=[op.xdim xx];
            elseif(ii==2)
                xx=1:op.xdim;            
            else
                xx=2:op.xdim; xx=[xx 1];
            end
        elseif((4<=ii)&&(ii<=5))
            yy=1:op.ydim;

            if(ii==4)
                xx=1:op.xdim-1; xx=[op.xdim xx];
            else
                xx=2:op.xdim; xx=[xx 1];
            end
        else
            yy=2:op.ydim; yy=[yy 1];

            if(ii==6)
                xx=1:op.xdim-1; xx=[op.xdim xx];
            elseif(ii==7)
                xx=1:op.xdim;            
            else
                xx=2:op.xdim; xx=[xx 1];
            end        
        end
    else
        if(ii==1)
            yy=1:op.ydim-1; yy=[op.ydim yy];
            xx=1:op.xdim; 
        elseif(ii==2)
            yy=1:op.ydim;
            xx=1:op.xdim-1; xx=[op.xdim xx];
        elseif(ii==3)
            yy=1:op.ydim;
            xx=2:op.xdim; xx=[xx 1];
        else
            yy=2:op.ydim; yy=[yy 1];
            xx=1:op.xdim;                 
        end
    end
        
    tmp=reshape(eye(op.components,op.components),[1,op.components^2]);
        
    [y,x]=meshgrid(yy,xx); y=y(:)'; x=x(:)';
    ind=(0:op.components-1)*op.components;
    ind=ind+op.xdim*(y-1)+x;
        
    tmp(ind)=-1;
    H(:,:,ii)=reshape(tmp,[op.components,op.components])';
end