/*
 * Decompiled with CFR 0.152.
 */
package kayttoliittyma;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import kayttoliittyma.Etusivu;
import kayttoliittyma.NappainKuuntelija;
import kayttoliittyma.ValittuIkkuna;
import peli.Peli;
import peli.asetukset.PelinAsetukset;
import peli.asetukset.logiikka.Asetukset;
import peli.asetukset.logiikka.Ulottuvuudet;
import peli.ennatyslista.Ennatyslistaaja;
import valmiskomponentit.Ikkuna;

public class BlockOut
implements Runnable {
    private JFrame kehys;
    private ValittuIkkuna valittuIkkuna;
    private HashMap<ValittuIkkuna, Ikkuna> ikkunat;
    private Etusivu etusivu;
    private Peli peli;
    private PelinAsetukset pelinAsetukset;
    private Ennatyslistaaja ennatyslistaaja;

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new BlockOut());
    }

    @Override
    public void run() {
        this.luoIkkunat();
        this.kehys = new JFrame();
        this.kehys.addKeyListener(new NappainKuuntelija(this));
        this.luoAloitusIkkuna();
        this.kehys.setTitle("BlockOut 1.3.1");
        this.kehys.setSize(800, 600);
        this.kehys.setBackground(Color.BLACK);
        this.kehys.setDefaultCloseOperation(3);
        this.kehys.setVisible(true);
    }

    private void luoAloitusIkkuna() {
        this.etusivu = new Etusivu(this);
        this.kehys.add((Component)this.etusivu, "South");
        this.kehys.add((Component)this.ikkunat.get((Object)ValittuIkkuna.TYHJA), "Center");
    }

    private void luoIkkunat() {
        this.ikkunat = new HashMap();
        this.ikkunat.put(ValittuIkkuna.TYHJA, new Ikkuna());
        this.pelinAsetukset = new PelinAsetukset(this, "asetukset.javafile");
        this.ikkunat.put(ValittuIkkuna.ASETUKSET, this.pelinAsetukset);
        this.ennatyslistaaja = new Ennatyslistaaja();
        this.ikkunat.put(ValittuIkkuna.ENNATYSLISTA, this.ennatyslistaaja);
        this.valittuIkkuna = ValittuIkkuna.TYHJA;
    }

    public Ikkuna annaJPanel() {
        return this.ikkunat.get((Object)this.valittuIkkuna);
    }

    public void vaihdaJPanel(ValittuIkkuna valittuIkkuna) {
        this.asetaPeliTarvittaessaTauolle(valittuIkkuna);
        if (this.valittuIkkuna == ValittuIkkuna.ASETUKSET) {
            this.pelinAsetukset.vaihdaAsetuksetPanelia();
        }
        this.valittuIkkuna = valittuIkkuna;
        this.kehys.getContentPane().remove(1);
        this.kehys.getContentPane().add(this.ikkunat.get((Object)valittuIkkuna));
        if (valittuIkkuna == ValittuIkkuna.ENNATYSLISTA) {
            this.asetaUusimmatAsetuksetEnnatyslistaan();
        }
        this.etusivu.vaihdaNappuloidenAktiivisuuksiaTasmaaviksi(valittuIkkuna);
        this.ikkunat.get((Object)valittuIkkuna).revalidate();
        this.kehys.repaint();
    }

    private void asetaUusimmatAsetuksetEnnatyslistaan() {
        Asetukset asetukset = this.pelinAsetukset.annaValitutAsetukset();
        Ulottuvuudet ulottuvuudet = asetukset.annaUlottuvuudet();
        this.ennatyslistaaja.saadaEnnatyslistanParametrit(ulottuvuudet.annaLeveys(), ulottuvuudet.annaKorkeus(), ulottuvuudet.annaSyvyys(), asetukset.annaPalikkasetti());
    }

    public void aloitaPeli() {
        if (this.onkoPeliKaynnissa()) {
            this.peli.lopetaPeli();
            this.etusivu.vaihdaTaukoNappulanTeksti("Tauko");
        }
        int n = this.ikkunat.get((Object)this.valittuIkkuna).getWidth();
        int n2 = this.ikkunat.get((Object)this.valittuIkkuna).getHeight();
        this.ennatyslistaaja.poistaEnnatyslistanKysely();
        this.peli = new Peli(this, this.pelinAsetukset.annaValitutAsetukset(), this.ennatyslistaaja, n, n2);
        this.peli.aloitaPeli();
        this.ikkunat.put(ValittuIkkuna.PELI, this.peli);
        this.vaihdaJPanel(ValittuIkkuna.PELI);
    }

    public void asetaPeliTarvittaessaTauolle(ValittuIkkuna valittuIkkuna) {
        if (!this.onkoPeliKaynnissa()) {
            return;
        }
        if (this.valittuIkkuna == ValittuIkkuna.PELI && valittuIkkuna != ValittuIkkuna.PELI) {
            this.asetaPeliTauolle(true);
        }
    }

    public void asetaPeliTauolle(boolean bl) {
        if (!this.ikkunat.containsKey((Object)ValittuIkkuna.PELI)) {
            return;
        }
        this.peli.asetaPeliTauolle(bl);
        if (bl) {
            this.etusivu.vaihdaTaukoNappulanTeksti("Jatka");
        } else {
            this.etusivu.vaihdaTaukoNappulanTeksti("Tauko");
            this.kaynnistaPeliTauolta();
        }
    }

    private void kaynnistaPeliTauolta() {
        this.peli.asetaUudetAsetukset(this.pelinAsetukset.annaValitutAsetukset());
        this.vaihdaJPanel(ValittuIkkuna.PELI);
    }

    public void lopetaPeli() {
        this.etusivu.vaihdaTaukoNappulanTeksti("Tauko");
        boolean bl = this.peli.lopetaPeli();
        this.peli = null;
        this.ikkunat.remove((Object)ValittuIkkuna.PELI);
        if (bl) {
            this.vaihdaJPanel(ValittuIkkuna.ENNATYSLISTA);
        } else if (this.valittuIkkuna == ValittuIkkuna.PELI) {
            this.vaihdaJPanel(ValittuIkkuna.TYHJA);
        } else {
            this.etusivu.vaihdaNappuloidenAktiivisuuksiaTasmaaviksi(this.valittuIkkuna);
        }
    }

    public boolean onkoPeliKaynnissa() {
        return this.ikkunat.containsKey((Object)ValittuIkkuna.PELI);
    }
}

