/*
 * Decompiled with CFR 0.152.
 */
package kayttoliittyma;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import kayttoliittyma.BlockOut;
import kayttoliittyma.ValittuIkkuna;
import valmiskomponentit.Nappula;

public class Etusivu
extends JPanel {
    private BlockOut kayttis;
    private Nappula tauko;
    private Nappula uusiPeli;
    private Nappula lopeta;
    private Nappula asetukset;
    private Nappula ennatyslista;

    public Etusivu(BlockOut blockOut) {
        this.kayttis = blockOut;
        this.setLayout(new GridLayout(1, 3));
        this.luoNappulat();
    }

    private void luoNappulat() {
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        this.tauko = new Nappula("Tauko");
        this.tauko.addActionListener(new TaukoNappulaKuuntelija(this.kayttis, this.tauko));
        this.tauko.setEnabled(false);
        this.tauko.setFocusable(false);
        jPanel.add(this.tauko);
        this.uusiPeli = new Nappula("Uusi peli");
        this.uusiPeli.addActionListener(new UusiPeliNappulaKuuntelija(this.kayttis));
        this.uusiPeli.setEnabled(true);
        this.uusiPeli.setFocusable(false);
        jPanel.add(this.uusiPeli);
        this.lopeta = new Nappula("Lopeta");
        this.lopeta.addActionListener(new LopetaNappulaKuuntelija(this.kayttis));
        this.lopeta.setEnabled(false);
        this.lopeta.setFocusable(false);
        jPanel.add(this.lopeta);
        this.add(jPanel);
        this.asetukset = new Nappula("Asetukset");
        this.asetukset.addActionListener(new AsetuksetNappulaKuuntelija(this.kayttis));
        this.asetukset.setEnabled(true);
        this.asetukset.setFocusable(false);
        this.add(this.asetukset);
        this.ennatyslista = new Nappula("Enn\u00e4tyslista");
        this.ennatyslista.addActionListener(new EnnatyslistaNappulaKuuntelija(this.kayttis));
        this.ennatyslista.setEnabled(true);
        this.ennatyslista.setFocusable(false);
        this.add(this.ennatyslista);
    }

    public void vaihdaTaukoNappulanTeksti(String string) {
        this.tauko.setText(string);
    }

    public void vaihdaNappuloidenAktiivisuuksiaTasmaaviksi(ValittuIkkuna valittuIkkuna) {
        if (valittuIkkuna == ValittuIkkuna.PELI) {
            this.tauko.setEnabled(true);
            this.lopeta.setEnabled(true);
        } else if (!this.kayttis.onkoPeliKaynnissa()) {
            this.tauko.setEnabled(false);
            this.lopeta.setEnabled(false);
        }
        if (valittuIkkuna == ValittuIkkuna.ASETUKSET) {
            this.asetukset.setEnabled(false);
        } else {
            this.asetukset.setEnabled(true);
        }
        if (valittuIkkuna == ValittuIkkuna.ENNATYSLISTA) {
            this.ennatyslista.setEnabled(false);
        } else {
            this.ennatyslista.setEnabled(true);
        }
    }

    private static class EnnatyslistaNappulaKuuntelija
    implements ActionListener {
        private BlockOut kayttis;

        public EnnatyslistaNappulaKuuntelija(BlockOut blockOut) {
            this.kayttis = blockOut;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.kayttis.vaihdaJPanel(ValittuIkkuna.ENNATYSLISTA);
        }
    }

    private static class AsetuksetNappulaKuuntelija
    implements ActionListener {
        private BlockOut kayttis;

        public AsetuksetNappulaKuuntelija(BlockOut blockOut) {
            this.kayttis = blockOut;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.kayttis.vaihdaJPanel(ValittuIkkuna.ASETUKSET);
        }
    }

    private static class LopetaNappulaKuuntelija
    implements ActionListener {
        private BlockOut kayttis;

        public LopetaNappulaKuuntelija(BlockOut blockOut) {
            this.kayttis = blockOut;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.kayttis.lopetaPeli();
        }
    }

    private static class UusiPeliNappulaKuuntelija
    implements ActionListener {
        private BlockOut kayttis;

        public UusiPeliNappulaKuuntelija(BlockOut blockOut) {
            this.kayttis = blockOut;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.kayttis.aloitaPeli();
        }
    }

    private static class TaukoNappulaKuuntelija
    implements ActionListener {
        private BlockOut kayttis;
        private Nappula nappula;

        public TaukoNappulaKuuntelija(BlockOut blockOut, Nappula nappula) {
            this.kayttis = blockOut;
            this.nappula = nappula;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.nappula.getText().equals("Tauko")) {
                this.kayttis.asetaPeliTauolle(true);
            } else {
                this.kayttis.asetaPeliTauolle(false);
            }
        }
    }
}

