/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import kayttoliittyma.BlockOut;
import peli.Peli;
import peli.asetukset.logiikka.Nappainsetti;

public class NappainKuuntelija
implements KeyListener {
    private Peli peli;
    private BlockOut kayttis;
    private Nappainsetti nappainsetti;

    public NappainKuuntelija(Peli peli, BlockOut blockOut, Nappainsetti nappainsetti) {
        this.peli = peli;
        this.kayttis = blockOut;
        this.nappainsetti = nappainsetti;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.peli.onkoGameOver()) {
            if (this.peli.onkoGameOveristaSekunti()) {
                this.kayttis.lopetaPeli();
            }
            return;
        }
        this.onkoTauko(keyEvent.getKeyCode());
        if (this.peli.onkoTauolla()) {
            return;
        }
        this.kasittelePelisiirto(keyEvent.getKeyCode());
    }

    private void kasittelePelisiirto(int n) {
        if (this.onkoSiirto(n)) {
            return;
        }
        if (this.onkoPyoritys(n)) {
            return;
        }
        if (this.onkoTiputus(n)) {
            return;
        }
    }

    private boolean onkoSiirto(int n) {
        if (n == this.nappainsetti.annaYlosNappain()) {
            this.peli.annaTippuvaPalikka().siirra(0, -1);
        } else if (n == this.nappainsetti.annaAlasNappain()) {
            this.peli.annaTippuvaPalikka().siirra(0, 1);
        } else if (n == this.nappainsetti.annaVasemmalleNappain()) {
            this.peli.annaTippuvaPalikka().siirra(-1, 0);
        } else if (n == this.nappainsetti.annaOikealleNappain()) {
            this.peli.annaTippuvaPalikka().siirra(1, 0);
        } else {
            return false;
        }
        return true;
    }

    private boolean onkoPyoritys(int n) {
        if (n == this.nappainsetti.annaYlapuoliEsilleNappain()) {
            this.peli.annaTippuvaPalikka().pyoritaSuuntaEsille(0, -1);
        } else if (n == this.nappainsetti.annaAlapuoliEsilleNappain()) {
            this.peli.annaTippuvaPalikka().pyoritaSuuntaEsille(0, 1);
        } else if (n == this.nappainsetti.annaVasenPuoliEsilleNappain()) {
            this.peli.annaTippuvaPalikka().pyoritaSuuntaEsille(-1, 0);
        } else if (n == this.nappainsetti.annaOikeaPuoliEsilleNappain()) {
            this.peli.annaTippuvaPalikka().pyoritaSuuntaEsille(1, 0);
        } else if (n == this.nappainsetti.annaKierraMyotapaivaanNappain()) {
            this.peli.annaTippuvaPalikka().pyoritaMyotapaivaan(true);
        } else if (n == this.nappainsetti.annaKierraVastapaivaanNappain()) {
            this.peli.annaTippuvaPalikka().pyoritaMyotapaivaan(false);
        } else {
            return false;
        }
        return true;
    }

    private boolean onkoTiputus(int n) {
        if (n == this.nappainsetti.annaTiputaNappain()) {
            this.peli.annaTippuvaPalikka().tiputaPohjalle();
            return true;
        }
        if (n == this.nappainsetti.annaTiputaYksiKerrosNappain()) {
            this.peli.tiputaPalikkaa(-1L);
            return true;
        }
        return false;
    }

    private boolean onkoTauko(int n) {
        if (n == this.nappainsetti.annaTaukoNappain()) {
            this.kayttis.asetaPeliTauolle(!this.peli.onkoTauolla());
            return true;
        }
        return false;
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }
}

