/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.awt.Graphics;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import kayttoliittyma.BlockOut;
import peli.Ajastin;
import peli.NappainKuuntelija;
import peli.asetukset.logiikka.Asetukset;
import peli.asetukset.logiikka.Ulottuvuudet;
import peli.ennatyslista.Ennatyslistaaja;
import peli.grafiikka.Piirturi;
import peli.logiikka.Kentta;
import peli.logiikka.Palikkasetti;
import peli.logiikka.Palikkavarasto;
import peli.logiikka.Pistelaskija;
import peli.logiikka.TippuvaPalikka;
import valmiskomponentit.Ikkuna;

public class Peli
extends Ikkuna {
    private BlockOut kayttis;
    private Piirturi piirturi;
    private Ennatyslistaaja ennatyslistaaja;
    private Kentta kentta;
    private Palikkavarasto palikkavarasto;
    private TippuvaPalikka tippuvaPalikka;
    private double tiputustenVali;
    private long viimeAjastushetki;
    private double pohjaAika = 5.51;
    private double aikatasokerroin = 0.64;
    private Pistelaskija pistelaskija;
    private int taso;
    private int pelattujaPalikoita;
    private Palikkasetti palikkasetti;
    private boolean tauolla;
    private boolean gameOver;
    private long gameOverHetki;
    private boolean aanetPaalla;
    private Clip tasoAani;

    public Peli(BlockOut blockOut, Asetukset asetukset, Ennatyslistaaja ennatyslistaaja, int n, int n2) {
        this.kayttis = blockOut;
        this.ennatyslistaaja = ennatyslistaaja;
        this.palikkasetti = asetukset.annaPalikkasetti();
        this.asetaPeliValmiiksi(asetukset, n, n2);
    }

    private void asetaPeliValmiiksi(Asetukset asetukset, int n, int n2) {
        this.alustaTilanne(asetukset.annaAloitustaso());
        Ulottuvuudet ulottuvuudet = asetukset.annaUlottuvuudet();
        this.alustaLogiikka(asetukset, ulottuvuudet);
        this.alustaGrafiikka(asetukset, ulottuvuudet, n, n2);
        NappainKuuntelija nappainKuuntelija = new NappainKuuntelija(this, this.kayttis, asetukset.annaNappainsetti());
        this.addKeyListener(nappainKuuntelija);
        this.haeAanet(asetukset.annaAanet());
    }

    private void alustaTilanne(int n) {
        this.tauolla = true;
        this.gameOver = false;
        this.gameOverHetki = -1L;
        this.taso = n;
        this.pelattujaPalikoita = 0;
        this.tiputustenVali = this.pohjaAika * Math.pow(this.aikatasokerroin, this.taso);
    }

    private void alustaLogiikka(Asetukset asetukset, Ulottuvuudet ulottuvuudet) {
        this.pistelaskija = new Pistelaskija(this, ulottuvuudet.annaSyvyys(), asetukset.annaPalikkasetti());
        this.kentta = new Kentta(this, this.pistelaskija, ulottuvuudet);
        this.palikkavarasto = new Palikkavarasto(asetukset.annaPalikkasetti());
    }

    private void alustaGrafiikka(Asetukset asetukset, Ulottuvuudet ulottuvuudet, int n, int n2) {
        this.piirturi = new Piirturi(this, n, n2, ulottuvuudet, asetukset.annaPalikkasetti(), asetukset.annaVarit(), this.pistelaskija, this.ennatyslistaaja);
    }

    private void haeAanet(boolean bl) {
        this.aanetPaalla = bl;
        URL uRL = Peli.class.getResource("Taso.wav");
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(uRL);
            this.tasoAani = AudioSystem.getClip();
            this.tasoAani.open(audioInputStream);
            FloatControl floatControl = (FloatControl)this.tasoAani.getControl(FloatControl.Type.MASTER_GAIN);
            floatControl.setValue(-10.0f);
        }
        catch (Exception exception) {
            System.out.println("\u00c4\u00e4nitiedoston avaus ei onnistunut.");
            this.aanetPaalla = false;
        }
    }

    public void asetaUudetAsetukset(Asetukset asetukset) {
        this.piirturi.asetaUudetAsetukset(asetukset.annaUlottuvuudet().annaLeikkauspiste(), asetukset.annaVarit());
        this.removeKeyListener(this.getKeyListeners()[0]);
        this.addKeyListener(new NappainKuuntelija(this, this.kayttis, asetukset.annaNappainsetti()));
        this.aanetPaalla = asetukset.annaAanet();
    }

    public void aloitaPeli() {
        this.haeTippuvaPalikka();
        this.tauolla = false;
        this.ajastaSeuraavaTiputus();
    }

    public void asetaPeliTauolle(boolean bl) {
        if (this.tauolla && !bl) {
            this.ajastaSeuraavaTiputus();
        }
        if (!this.tauolla && bl) {
            this.paivita();
        }
        this.tauolla = bl;
    }

    public boolean onkoTauolla() {
        return this.tauolla;
    }

    public boolean lopetaPeli() {
        this.gameOver = true;
        this.asetaPeliTauolle(true);
        return this.selvitaEnnatyslistallePaasy();
    }

    private boolean selvitaEnnatyslistallePaasy() {
        int n;
        int n2;
        int n3;
        int n4 = this.pistelaskija.annaPisteet();
        if (!this.ennatyslistaaja.paaseekoListalle(n4, n3 = this.kentta.annaLeveys(), n2 = this.kentta.annaKorkeus(), n = this.kentta.annaSyvyys(), this.palikkasetti)) {
            return false;
        }
        this.ennatyslistaaja.annaEnnatyslistalleKasiteltavaksi(n4, n3, n2, n, this.palikkasetti);
        return true;
    }

    public boolean onkoGameOver() {
        return this.gameOver;
    }

    public boolean onkoGameOveristaSekunti() {
        return this.gameOverHetki != -1L && System.currentTimeMillis() - 1000L >= this.gameOverHetki;
    }

    public int annaTaso() {
        return this.taso;
    }

    public int annaPelattujenPalojenMaara() {
        return this.pelattujaPalikoita;
    }

    public void lisaaPelattujenPalojenMaaraa(int n) {
        this.pelattujaPalikoita += n;
        if (this.taso < 10 && this.pelattujaPalikoita >= 15 * (this.kentta.annaLeveys() + this.kentta.annaKorkeus()) * (this.taso + 1)) {
            ++this.taso;
            this.tiputustenVali *= this.aikatasokerroin;
            if (this.aanetPaalla) {
                try {
                    this.tasoAani.start();
                    System.out.println("\u00c4\u00e4nen olisi pit\u00e4nyt soida.");
                }
                catch (Exception exception) {
                    System.out.println("Ongelma");
                    exception.printStackTrace();
                }
            }
        }
    }

    public Palikkasetti annaPalikkasetti() {
        return this.palikkasetti;
    }

    public void haeUusiPalikkaKenttaan() {
        this.haeTippuvaPalikka();
        this.paivita();
        this.ajastaSeuraavaTiputus();
    }

    private void haeTippuvaPalikka() {
        if (!this.kentta.onkoKentanEdustaVapaana()) {
            this.tauolla = true;
            this.gameOver = true;
            this.gameOverHetki = System.currentTimeMillis();
            return;
        }
        this.tippuvaPalikka = new TippuvaPalikka(this.palikkavarasto.annaPalikka(), this.kentta, this);
    }

    public TippuvaPalikka annaTippuvaPalikka() {
        return this.tippuvaPalikka;
    }

    public void tiputaPalikkaa(long l) {
        if (l > 0L && l != this.viimeAjastushetki) {
            return;
        }
        this.viimeAjastushetki = System.currentTimeMillis();
        if (!this.tippuvaPalikka.siirra(0, 0, 1)) {
            this.tippuvaPalikka.tiputaPohjalle();
        } else {
            this.ajastaSeuraavaTiputus();
        }
    }

    private void ajastaSeuraavaTiputus() {
        new Ajastin(this, this.tippuvaPalikka, (int)(this.tiputustenVali * 1000.0) + 160, this.viimeAjastushetki);
    }

    public void paivita() {
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.piirturi.piirra(graphics, this.kentta.annaKentta(), this.tippuvaPalikka, this.kentta.annaPalojaSisaltavienKerrostenMaara());
        if (this.gameOver) {
            boolean bl = this.ennatyslistaaja.paaseekoListalle(this.pistelaskija.annaPisteet(), this.kentta.annaLeveys(), this.kentta.annaKorkeus(), this.kentta.annaSyvyys(), this.palikkasetti);
            this.piirturi.piirraGameOver(graphics, this, bl);
        }
    }
}

