/*
 * Decompiled with CFR 0.152.
 */
package peli.asetukset;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Scanner;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kayttoliittyma.BlockOut;
import peli.asetukset.grafiikka.AsetuksetPaneli;
import peli.asetukset.grafiikka.NappainKuuntelija;
import peli.asetukset.grafiikka.Nappainpaletti;
import peli.asetukset.grafiikka.TalletetutAsetuksetPaneli;
import peli.asetukset.logiikka.Asetukset;
import valmiskomponentit.Ikkuna;
import valmiskomponentit.Nappula;
import varipaletti.Varipaletti;

public class PelinAsetukset
extends Ikkuna {
    private BlockOut kayttis;
    private String tallenneosoite;
    private boolean tallenteenAvausKaynnissa;
    private ArrayList<Asetukset> tallennetutAsetukset;
    private int valittuAsetus;
    private TalletetutAsetuksetPaneli talletetutPaneli;
    private AsetuksetPaneli asetuksetPaneli;
    private NappainKuuntelija nappainKuuntelija;

    public PelinAsetukset(BlockOut blockOut, String string) {
        this.kayttis = blockOut;
        this.tallenneosoite = string;
        this.avaaTallennokset();
        this.luoKomponentit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void avaaTallennokset() {
        this.tallennetutAsetukset = new ArrayList();
        this.valittuAsetus = 0;
        this.tallenteenAvausKaynnissa = true;
        Scanner scanner = null;
        try {
            scanner = new Scanner(new File(this.tallenneosoite));
            this.lueTallennokset(scanner);
        }
        catch (Exception exception) {
            System.out.println("Tiedoston: asetukset avaaminen ei onnistunut. (Olemassaolevan tiedoston tulee olla samassa kansiossa jar:n kanssa.) Luodaan uusi, joka tallennetaan kun muutoksia tehdaan.");
            this.alustaAsetukset();
        }
        finally {
            try {
                scanner.close();
            }
            catch (Exception exception) {}
        }
        this.tallenteenAvausKaynnissa = false;
    }

    private void alustaAsetukset() {
        this.tallennetutAsetukset = new ArrayList();
        Asetukset asetukset = new Asetukset(this);
        asetukset.asetaAsetustenNimi("Perusasetukset");
        this.tallennetutAsetukset.add(asetukset);
    }

    private void lueTallennokset(Scanner scanner) throws Exception {
        int n = 0;
        if (scanner.hasNextLine()) {
            String[] stringArray = scanner.nextLine().split("/");
            this.valittuAsetus = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        for (int i = 1; i <= n; ++i) {
            Asetukset asetukset = new Asetukset(this);
            asetukset.avaaAsetukset(scanner);
            this.tallennetutAsetukset.add(asetukset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tallennaTallennokset() {
        if (this.tallenteenAvausKaynnissa) {
            return;
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new FileWriter(new File(this.tallenneosoite));
            this.kirjoitaTallennokset((FileWriter)outputStreamWriter);
        }
        catch (Exception exception) {
            System.out.println("Asetusten tallennuksessa ilmeni ongelma.");
            exception.printStackTrace();
        }
        finally {
            try {
                outputStreamWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    private void kirjoitaTallennokset(FileWriter fileWriter) throws Exception {
        int n = this.tallennetutAsetukset.size();
        fileWriter.write(this.valittuAsetus + "/" + n + "\n");
        for (Asetukset asetukset : this.tallennetutAsetukset) {
            asetukset.tallennaAsetukset(fileWriter);
        }
    }

    public void luoKomponentit() {
        this.setLayout(new BorderLayout());
        this.luoOtsikko();
        this.talletetutPaneli = new TalletetutAsetuksetPaneli(this, this.tallennetutAsetukset, this.valittuAsetus);
        this.talletetutPaneli.setOpaque(false);
        this.add((Component)this.talletetutPaneli, "West");
        this.asetuksetPaneli = new AsetuksetPaneli(this.kayttis, this, this.talletetutPaneli, this.annaValitutAsetukset(), this.valittuAsetus != 0);
        this.asetuksetPaneli.setOpaque(false);
        this.add((Component)this.asetuksetPaneli, "Center");
        this.nappainKuuntelija = new NappainKuuntelija(this.asetuksetPaneli);
        this.addKeyListener(this.nappainKuuntelija);
    }

    public void luoOtsikko() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel("Asetukset", 0);
        String string = this.haeFontti();
        int n = 48;
        if (string.toLowerCase().contains("comic")) {
            n = 40;
        }
        jLabel.setFont(new Font(string, 0, n));
        jLabel.setForeground(Color.WHITE);
        jPanel.add((Component)jLabel, "Center");
        Nappula nappula = new Nappula("Alusta asetussetti");
        nappula.setFocusable(false);
        nappula.asetaNappulanKavennus(10);
        this.add((Component)jPanel, "North");
    }

    public void vaihdaValittuaAsetusta(int n) {
        if (n < -1 || n >= this.annaAsetustenMaara()) {
            return;
        }
        if (n == -1) {
            this.luoUusiAsetus();
        } else {
            this.valittuAsetus = n;
        }
        this.tallennaTallennokset();
        this.vaihdaAsetuksetPanelia();
        this.revalidate();
    }

    private void luoUusiAsetus() {
        this.tallennetutAsetukset.add(new Asetukset(this));
        this.valittuAsetus = this.annaAsetustenMaara() - 1;
    }

    public void vaihdaAsetuksetPanelia() {
        this.asetuksetPaneli = new AsetuksetPaneli(this.kayttis, this, this.talletetutPaneli, this.annaValitutAsetukset(), this.valittuAsetus != 0);
        this.asetuksetPaneli.setOpaque(false);
        this.remove(2);
        this.add((Component)this.asetuksetPaneli, "Center");
        this.nappainKuuntelija.asetaUusiKuuntelija(this.asetuksetPaneli);
    }

    public void naytaNappaimet() {
        this.remove(2);
        Nappainpaletti nappainpaletti = new Nappainpaletti(this);
        this.add((Component)nappainpaletti, "Center");
        this.nappainKuuntelija.asetaUusiKuuntelija(nappainpaletti);
        this.revalidate();
    }

    public void naytaVarit() {
        this.remove(2);
        Varipaletti varipaletti = new Varipaletti(this);
        this.add((Component)varipaletti, "Center");
        this.nappainKuuntelija.asetaUusiKuuntelija(varipaletti);
        this.revalidate();
    }

    public int annaAsetustenMaara() {
        return this.tallennetutAsetukset.size();
    }

    public Asetukset annaValitutAsetukset() {
        return this.tallennetutAsetukset.get(this.valittuAsetus);
    }

    public int annaValittuAsetus() {
        return this.valittuAsetus;
    }

    public void annaVariAsetuksille(Color color) {
    }

    private String haeFontti() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        String[] stringArray = new String[]{"Herculanum", "ComicSansMS", "Comic Sans MS", "ArialMT", "Arial"};
        for (String object : stringArray) {
            for (Font font : fontArray) {
                if (!font.getFontName().equals(object)) continue;
                return font.getFontName();
            }
        }
        for (Font font : fontArray) {
            if (!font.getFontName().toLowerCase().contains("arial")) continue;
            return font.getFontName();
        }
        return "futura";
    }
}

