/*
 * Decompiled with CFR 0.152.
 */
package peli.asetukset.grafiikka;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kayttoliittyma.BlockOut;
import peli.asetukset.PelinAsetukset;
import peli.asetukset.grafiikka.AaniNappulaKuuntelija;
import peli.asetukset.grafiikka.PalikkasettiPaneli;
import peli.asetukset.grafiikka.TalletetutAsetuksetPaneli;
import peli.asetukset.grafiikka.UlottuvuusPaneli;
import peli.asetukset.grafiikka.VaihtelevaPaneli;
import peli.asetukset.logiikka.Asetukset;
import valmiskomponentit.Nappula;

public class AsetuksetPaneli
extends JPanel
implements KeyListener {
    private BlockOut kayttis;
    private PelinAsetukset pelinAsetukset;
    private TalletetutAsetuksetPaneli talletetutPaneli;
    private Asetukset asetukset;
    private JLabel asetuksenNimi;
    private boolean muokattavissa;
    private UlottuvuusPaneli ulottuvuusPaneli;
    private String fontinNimi;

    public AsetuksetPaneli(BlockOut blockOut, PelinAsetukset pelinAsetukset, TalletetutAsetuksetPaneli talletetutAsetuksetPaneli, Asetukset asetukset, boolean bl) {
        this.kayttis = blockOut;
        this.pelinAsetukset = pelinAsetukset;
        this.talletetutPaneli = talletetutAsetuksetPaneli;
        this.asetukset = asetukset;
        this.muokattavissa = bl;
        this.haeFontti();
        this.luoKomponentit();
    }

    private void luoKomponentit() {
        this.setLayout(new BorderLayout());
        this.luoAsetuksenNimiPaneli();
        this.luoAsetuksetAlue();
        JLabel jLabel = new JLabel("-");
        jLabel.setOpaque(false);
        this.add((Component)jLabel, "South");
    }

    private void luoAsetuksenNimiPaneli() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3));
        jPanel.setOpaque(false);
        this.add((Component)jPanel, "North");
        Font font = new Font(this.fontinNimi, 0, 24);
        JLabel jLabel = new JLabel("Nimi: ", 4);
        jLabel.setFocusable(false);
        jLabel.setFont(font);
        jLabel.setForeground(Color.WHITE);
        jPanel.add(jLabel);
        this.asetuksenNimi = new JLabel(this.asetukset.annaAsetustenNimi(), 2);
        this.asetuksenNimi.setFocusable(false);
        this.asetuksenNimi.setFont(font);
        this.asetuksenNimi.setForeground(Color.WHITE);
        jPanel.add(this.asetuksenNimi);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!this.muokattavissa) {
            return;
        }
        String string = this.asetuksenNimi.getText();
        this.kasitteleNappaintapahtuma(string, keyEvent);
        this.asetuksenNimi.repaint();
    }

    private void kasitteleNappaintapahtuma(String string, KeyEvent keyEvent) {
        String string2 = keyEvent.getKeyChar() + "";
        if (keyEvent.getKeyCode() == 10) {
            this.asetukset.asetaAsetustenNimi(string);
            this.talletetutPaneli.vaihdaNappulanTeksti(string);
        } else if (keyEvent.getKeyCode() == 8) {
            if (string.length() != 0) {
                this.asetuksenNimi.setText(string.substring(0, string.length() - 1));
            }
        } else if (string2.matches("\\p{ASCII}|[\u00e5\u00e4\u00f6\u00c5\u00c4\u00d6\u00df\u00fc\u00dc]")) {
            this.asetuksenNimi.setText(string + string2);
        }
    }

    private void luoAsetuksetAlue() {
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        this.add(jPanel);
        jPanel.setOpaque(false);
        this.luoVasenPalsta(jPanel);
        this.luoKeskinPalsta(jPanel);
        this.luoOikeaVaihtelevaPalsta("Taso");
    }

    private void luoVasenPalsta(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel2.setOpaque(false);
        jPanel2.add(new PalikkasettiPaneli(this.asetukset, this.fontinNimi));
        Nappula nappula = new Nappula("Palikat");
        nappula.setFocusable(false);
        nappula.asetaFontti(this.fontinNimi, 20);
        nappula.setEnabled(false);
        jPanel2.add(nappula);
        jPanel.add(jPanel2);
    }

    private void luoKeskinPalsta(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel2.setOpaque(false);
        this.ulottuvuusPaneli = new UlottuvuusPaneli(this, this.asetukset, this.fontinNimi);
        jPanel2.add(this.ulottuvuusPaneli);
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1));
        Nappula nappula = new Nappula("Nappulat");
        nappula.setFocusable(false);
        nappula.asetaFontti(this.fontinNimi, 20);
        nappula.setEnabled(this.muokattavissa);
        nappula.addActionListener(new NappainNappulaKuuntelija(this.pelinAsetukset));
        jPanel3.add(nappula);
        Nappula nappula2 = new Nappula("V\u00e4rit");
        nappula2.setFocusable(false);
        nappula2.asetaFontti(this.fontinNimi, 20);
        nappula2.setEnabled(this.muokattavissa);
        nappula2.addActionListener(new VariNappulaKuuntelija(this.pelinAsetukset));
        jPanel3.add(nappula2);
        Nappula nappula3 = new Nappula("\u00c4\u00e4net p\u00e4\u00e4ll\u00e4");
        if (!this.asetukset.annaAanet()) {
            nappula3.setText("\u00c4\u00e4net poissa");
        }
        nappula3.setFocusable(false);
        nappula3.asetaFontti(this.fontinNimi, 20);
        nappula3.setEnabled(true);
        nappula3.addActionListener(new AaniNappulaKuuntelija(nappula3, this.asetukset));
        jPanel3.add(nappula3);
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
    }

    public void luoOikeaVaihtelevaPalsta(String string) {
        JPanel jPanel = (JPanel)this.getComponent(1);
        if (jPanel.getComponentCount() >= 3) {
            jPanel.remove(2);
        }
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.setOpaque(false);
        jPanel2.add(new VaihtelevaPaneli(this, this.asetukset, string, this.fontinNimi));
        jPanel.add(jPanel2);
        this.revalidate();
        this.repaint();
    }

    public void asetaVaihtelevaPalstaPerustilaan(int n) {
        this.ulottuvuusPaneli.asetaPyydettyArvo(n);
        this.luoOikeaVaihtelevaPalsta("Taso");
    }

    private void haeFontti() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        String[] stringArray = new String[]{"Herculanum", "ComicSansMS", "Comic Sans MS", "ArialMT", "Arial"};
        for (String object : stringArray) {
            for (Font font : fontArray) {
                if (!font.getFontName().equals(object)) continue;
                this.fontinNimi = font.getFontName();
                return;
            }
        }
        for (Font font : fontArray) {
            if (!font.getFontName().toLowerCase().contains("arial")) continue;
            this.fontinNimi = font.getFontName();
            return;
        }
        this.fontinNimi = "futura";
    }

    private static class VariNappulaKuuntelija
    implements ActionListener {
        private PelinAsetukset kohde;

        public VariNappulaKuuntelija(PelinAsetukset pelinAsetukset) {
            this.kohde = pelinAsetukset;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.kohde.naytaVarit();
        }
    }

    private static class NappainNappulaKuuntelija
    implements ActionListener {
        private PelinAsetukset kohde;

        public NappainNappulaKuuntelija(PelinAsetukset pelinAsetukset) {
            this.kohde = pelinAsetukset;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.kohde.naytaNappaimet();
        }
    }
}

