/*
 * Decompiled with CFR 0.152.
 */
package peli.asetukset.grafiikka;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import peli.asetukset.PelinAsetukset;
import peli.asetukset.logiikka.Nappainsetti;
import valmiskomponentit.Nappula;

public class Nappainpaletti
extends JPanel
implements KeyListener {
    private PelinAsetukset pelinAsetukset;
    private Nappainsetti nappainsetti;
    private ArrayList<Nappula> nappulat;
    private boolean kyselyAktivoitu;
    private String fontinNimi;

    public Nappainpaletti(PelinAsetukset pelinAsetukset) {
        this.pelinAsetukset = pelinAsetukset;
        this.nappainsetti = pelinAsetukset.annaValitutAsetukset().annaNappainsetti();
        this.haeFontti();
        this.nappulat = new ArrayList();
        this.luoKomponentit();
        this.kyselyAktivoitu = false;
    }

    private void luoKomponentit() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.luoSisennys();
        JPanel jPanel = new JPanel(new GridLayout(9, 2));
        jPanel.setOpaque(false);
        this.add((Component)jPanel, "Center");
        this.luoSiirrotJaPyoritykset();
        this.luoTiputuksetJaTauko();
        this.luoPaluu(jPanel);
    }

    private void luoSisennys() {
        JLabel jLabel = new JLabel("Sisennys:");
        jLabel.setFont(new Font(this.fontinNimi, 0, 30));
        this.add((Component)jLabel, "North");
        JLabel jLabel2 = new JLabel("     ");
        this.add((Component)jLabel2, "West");
        this.add((Component)jLabel2, "East");
    }

    private void luoSiirrotJaPyoritykset() {
        this.luoPari("Siirr\u00e4 yl\u00f6s", "ylos", this.nappainsetti.annaYlosNappain());
        this.luoPari("Yl\u00e4puoli esille", "ylapuoli esille", this.nappainsetti.annaYlapuoliEsilleNappain());
        this.luoPari("Siirr\u00e4 alas", "alas", this.nappainsetti.annaAlasNappain());
        this.luoPari("Alapuoli esille", "alapuoli esille", this.nappainsetti.annaAlapuoliEsilleNappain());
        this.luoPari("Siirr\u00e4 vasemmalle", "vasemmalle", this.nappainsetti.annaVasemmalleNappain());
        this.luoPari("Vasen puoli esille", "vasen puoli esille", this.nappainsetti.annaVasenPuoliEsilleNappain());
        this.luoPari("Siirr\u00e4 oikealle", "oikealle", this.nappainsetti.annaOikealleNappain());
        this.luoPari("Oikea puoli esille", "oikea puoli esille", this.nappainsetti.annaOikeaPuoliEsilleNappain());
        ((JPanel)this.getComponent(2)).add(new JPanel());
        this.luoPari("Py\u00f6rit\u00e4 my\u00f6t\u00e4p\u00e4iv\u00e4\u00e4n", "myotapaivaan", this.nappainsetti.annaKierraMyotapaivaanNappain());
        ((JPanel)this.getComponent(2)).add(new JPanel());
        this.luoPari("Py\u00f6rit\u00e4 vastap\u00e4iv\u00e4\u00e4n", "vastapaivaan", this.nappainsetti.annaKierraVastapaivaanNappain());
    }

    private void luoTiputuksetJaTauko() {
        this.luoPari("Tiputa pohjalle", "tiputa", this.nappainsetti.annaTiputaNappain());
        ((JPanel)this.getComponent(2)).add(new JPanel());
        this.luoPari("Tiputa yksi kerros", "tiputa yksi kerros", this.nappainsetti.annaTiputaYksiKerrosNappain());
        this.luoPari("Tauko", "tauko", this.nappainsetti.annaTaukoNappain());
    }

    private void luoPari(String string, String string2, int n) {
        JPanel jPanel = (JPanel)this.getComponent(2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.luoPari(jPanel2, string, string2, n);
        jPanel.add(jPanel2);
    }

    private void luoPari(JPanel jPanel, String string, String string2, int n) {
        Nappula nappula = new Nappula(this.selvitaNappaimenUlkonako(n));
        nappula.setName(string2);
        nappula.setFocusable(false);
        nappula.setFont(new Font(this.fontinNimi, 0, 16));
        nappula.setEnabled(true);
        nappula.addActionListener(new NappulaKuuntelija(this, n));
        nappula.setMaximumSize(new Dimension(40, 30));
        jPanel.add(nappula);
        this.nappulat.add(nappula);
        JLabel jLabel = new JLabel(" " + string);
        jLabel.setFont(new Font(this.fontinNimi, 0, 16));
        jLabel.setForeground(Color.WHITE);
        jPanel.add(jLabel);
    }

    private String selvitaNappaimenUlkonako(int n) {
        return n + "";
    }

    public void nappulaaPainettu(int n) {
        JPanel jPanel = (JPanel)this.getComponent(2);
        for (Nappula nappula : this.nappulat) {
            if (nappula.getText().equals("")) {
                nappula.setText(n + "");
                this.aktivoiKaikki();
                this.kyselyAktivoitu = false;
                break;
            }
            if (!nappula.getText().equals(n + "")) continue;
            nappula.setText("");
            this.deaktivoiMuut(nappula);
            this.kyselyAktivoitu = true;
            break;
        }
    }

    private void aktivoiKaikki() {
        for (Nappula nappula : this.nappulat) {
            nappula.setEnabled(true);
        }
    }

    private void deaktivoiMuut(Nappula nappula) {
        for (Nappula nappula2 : this.nappulat) {
            if (nappula2 == nappula) continue;
            nappula2.setEnabled(false);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.kyselyAktivoitu) {
            for (Nappula nappula : this.nappulat) {
                if (!nappula.getText().equals("")) continue;
                this.asetaUusiKeyCode(nappula, keyEvent.getKeyCode());
                return;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private void asetaUusiKeyCode(Nappula nappula, int n) {
        String string = nappula.getName();
        if (this.nappainsetti.asetaNappain(string, n)) {
            nappula.setText(n + "");
            this.muutaKuuntelijaa(nappula, n);
            this.aktivoiKaikki();
            this.kyselyAktivoitu = false;
        }
    }

    private void muutaKuuntelijaa(Nappula nappula, int n) {
        for (ActionListener actionListener : nappula.getActionListeners()) {
            if (!(actionListener instanceof NappulaKuuntelija)) continue;
            ((NappulaKuuntelija)actionListener).vaihdaNykyistaNappainta(n);
        }
    }

    private void luoPaluu(JPanel jPanel) {
        jPanel.add(new JPanel());
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.setOpaque(false);
        jPanel2.add(new JPanel());
        Nappula nappula = new Nappula("Palaa");
        nappula.setFocusable(false);
        nappula.asetaFontti(this.fontinNimi, 20);
        nappula.addActionListener(new PaluuKuuntelija(this.pelinAsetukset));
        jPanel2.add(nappula);
        jPanel.add(jPanel2);
    }

    private void haeFontti() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        String[] stringArray = new String[]{"Herculanum", "ComicSansMS", "Comic Sans MS", "ArialMT", "Arial"};
        for (String object : stringArray) {
            for (Font font : fontArray) {
                if (!font.getFontName().equals(object)) continue;
                this.fontinNimi = font.getFontName();
                return;
            }
        }
        for (Font font : fontArray) {
            if (!font.getFontName().toLowerCase().contains("arial")) continue;
            this.fontinNimi = font.getFontName();
            return;
        }
        this.fontinNimi = "futura";
    }

    private static class PaluuKuuntelija
    implements ActionListener {
        private PelinAsetukset pelinAsetukset;

        public PaluuKuuntelija(PelinAsetukset pelinAsetukset) {
            this.pelinAsetukset = pelinAsetukset;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.pelinAsetukset.vaihdaAsetuksetPanelia();
            this.pelinAsetukset.revalidate();
        }
    }

    private static class NappulaKuuntelija
    implements ActionListener {
        private Nappainpaletti kohde;
        private int nykyinenNappain;

        public NappulaKuuntelija(Nappainpaletti nappainpaletti, int n) {
            this.kohde = nappainpaletti;
            this.nykyinenNappain = n;
        }

        public void vaihdaNykyistaNappainta(int n) {
            this.nykyinenNappain = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.kohde.nappulaaPainettu(this.nykyinenNappain);
        }
    }
}

