/*
 * Decompiled with CFR 0.152.
 */
package peli.asetukset.grafiikka;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import peli.asetukset.logiikka.Asetukset;
import peli.logiikka.Palikkasetti;
import valmiskomponentit.Nappula;

public class PalikkasettiPaneli
extends JPanel {
    private Asetukset asetukset;
    private Palikkasetti setti;
    private String fontinNimi;

    public PalikkasettiPaneli(Asetukset asetukset, String string) {
        this.asetukset = asetukset;
        this.setti = asetukset.annaPalikkasetti();
        this.fontinNimi = string;
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.luoOtsikko();
        this.luoNappulat();
    }

    private void luoOtsikko() {
        JLabel jLabel = new JLabel("Palikkasetti");
        jLabel.setFont(new Font(this.fontinNimi, 0, 18));
        jLabel.setForeground(Color.WHITE);
        this.add(jLabel);
    }

    private void luoNappulat() {
        this.luoPalikkasettiNappula("FLAT");
        this.luoPalikkasettiNappula("BASIC");
        this.luoPalikkasettiNappula("EXTENDED");
        this.luoPalikkasettiNappula("PERSONAL");
    }

    private void luoPalikkasettiNappula(String string) {
        Nappula nappula = new Nappula(string);
        nappula.setFocusable(false);
        nappula.setFont(new Font(this.fontinNimi, 0, 16));
        Palikkasetti palikkasetti = this.haeNimellaSetti(string);
        if (this.setti == palikkasetti) {
            nappula.setEnabled(false);
        } else if (palikkasetti == Palikkasetti.PERSONAL) {
            nappula.setEnabled(false);
        } else {
            nappula.setEnabled(true);
        }
        nappula.addActionListener(new PalikkasettiKuuntelija(palikkasetti, this));
        this.add(nappula);
    }

    private Palikkasetti haeNimellaSetti(String string) {
        if (string.equals("BASIC")) {
            return Palikkasetti.BASIC;
        }
        if (string.equals("EXTENDED")) {
            return Palikkasetti.EXTENDED;
        }
        if (string.equals("PERSONAL")) {
            return Palikkasetti.PERSONAL;
        }
        return Palikkasetti.FLAT;
    }

    public void asetaPalikkasetti(Palikkasetti palikkasetti) {
        this.asetukset.asetaPalikkasetti(palikkasetti);
        for (Component component : this.getComponents()) {
            if (!(component instanceof Nappula)) continue;
            Nappula nappula = (Nappula)component;
            if (nappula.getText().equals(palikkasetti.annaNimi().toUpperCase())) {
                nappula.setEnabled(false);
                continue;
            }
            if (nappula.getText().equals("PERSONAL")) {
                nappula.setEnabled(false);
                continue;
            }
            nappula.setEnabled(true);
        }
        this.repaint();
    }

    private static class PalikkasettiKuuntelija
    implements ActionListener {
        private Palikkasetti setti;
        private PalikkasettiPaneli kohde;

        public PalikkasettiKuuntelija(Palikkasetti palikkasetti, PalikkasettiPaneli palikkasettiPaneli) {
            this.setti = palikkasetti;
            this.kohde = palikkasettiPaneli;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.kohde.asetaPalikkasetti(this.setti);
        }
    }
}

