/*
 * Decompiled with CFR 0.152.
 */
package peli.asetukset.grafiikka;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import peli.asetukset.PelinAsetukset;
import peli.asetukset.logiikka.Asetukset;
import valmiskomponentit.Nappula;

public class TalletetutAsetuksetPaneli
extends JPanel {
    private PelinAsetukset pelinAsetukset;
    private String fontinNimi;

    public TalletetutAsetuksetPaneli(PelinAsetukset pelinAsetukset, ArrayList<Asetukset> arrayList, int n) {
        this.pelinAsetukset = pelinAsetukset;
        this.haeFontti();
        this.setLayout(new GridLayout(7, 1));
        this.luoOtsikko();
        this.luoNappulat(arrayList, n);
    }

    private void luoOtsikko() {
        JTextArea jTextArea = new JTextArea("   Talletetut\n   asetukset");
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        int n = 30;
        if (this.fontinNimi.toLowerCase().contains("comic")) {
            n = 20;
        }
        jTextArea.setFont(new Font(this.fontinNimi, 0, n));
        jTextArea.setForeground(Color.WHITE);
        jTextArea.setOpaque(false);
        this.add(jTextArea);
    }

    private void luoNappulat(ArrayList<Asetukset> arrayList, int n) {
        int n2 = 0;
        for (Asetukset asetukset : arrayList) {
            this.luoUusiNappula(asetukset.annaAsetustenNimi(), n2, n2 == n);
            if (++n2 < 5) continue;
            System.out.println("Kaikki talletetut asetussetit eivat mahtuneet nakymaan.");
            break;
        }
        while (n2 < 5) {
            this.luoUusiNappula("Tyhja", -1, false);
            ++n2;
        }
    }

    private void luoUusiNappula(String string, int n, boolean bl) {
        Nappula nappula = new Nappula(string);
        nappula.asetaNappulanKavennus(20);
        nappula.asetaFontti(this.fontinNimi, 14);
        nappula.addActionListener(new Kuuntelija(this, n));
        nappula.setEnabled(!bl);
        nappula.setFocusable(false);
        nappula.setOpaque(false);
        this.add(nappula);
    }

    public void vaihdaAsetus(int n) {
        this.pelinAsetukset.vaihdaValittuaAsetusta(n);
        if (n == -1) {
            n = this.pelinAsetukset.annaAsetustenMaara() - 1;
            this.vaihdaNappulanTeksti("", n);
            this.annaNappulalleUusiKuuntelija(n);
        }
        this.vaihdaNappuloidenAktiivisuudet(n);
        this.repaint();
    }

    private void vaihdaNappuloidenAktiivisuudet(int n) {
        int n2 = 0;
        for (Component component : this.getComponents()) {
            if (!(component instanceof Nappula)) continue;
            Nappula nappula = (Nappula)component;
            nappula.setEnabled(n2 != n);
            ++n2;
        }
    }

    public void vaihdaNappulanTeksti(String string) {
        this.vaihdaNappulanTeksti(string, this.pelinAsetukset.annaValittuAsetus());
    }

    private void vaihdaNappulanTeksti(String string, int n) {
        int n2 = 0;
        for (Component component : this.getComponents()) {
            if (!(component instanceof Nappula)) continue;
            if (n2 == n) {
                Nappula nappula = (Nappula)component;
                nappula.setText(string);
                return;
            }
            ++n2;
        }
    }

    private void annaNappulalleUusiKuuntelija(int n) {
        int n2 = 0;
        for (Component component : this.getComponents()) {
            if (!(component instanceof Nappula)) continue;
            if (n2 == n) {
                Nappula nappula = (Nappula)component;
                this.liitaNappulalleUusiKuuntelija(nappula, n);
                return;
            }
            ++n2;
        }
    }

    private void liitaNappulalleUusiKuuntelija(Nappula nappula, int n) {
        for (ActionListener actionListener : nappula.getActionListeners()) {
            nappula.removeActionListener(actionListener);
        }
        nappula.addActionListener(new Kuuntelija(this, n));
    }

    private void haeFontti() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        String[] stringArray = new String[]{"Herculanum", "ComicSansMS", "Comic Sans MS", "ArialMT", "Arial"};
        for (String object : stringArray) {
            for (Font font : fontArray) {
                if (!font.getFontName().equals(object)) continue;
                this.fontinNimi = font.getFontName();
                return;
            }
        }
        for (Font font : fontArray) {
            if (!font.getFontName().toLowerCase().contains("arial")) continue;
            this.fontinNimi = font.getFontName();
            return;
        }
        this.fontinNimi = "futura";
    }

    private static class Kuuntelija
    implements ActionListener {
        private TalletetutAsetuksetPaneli paneli;
        private int id;

        public Kuuntelija(TalletetutAsetuksetPaneli talletetutAsetuksetPaneli, int n) {
            this.paneli = talletetutAsetuksetPaneli;
            this.id = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.paneli.vaihdaAsetus(this.id);
        }
    }
}

