/*
 * Decompiled with CFR 0.152.
 */
package peli.asetukset.grafiikka;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import peli.asetukset.grafiikka.AsetuksetPaneli;
import peli.asetukset.logiikka.Asetukset;
import valmiskomponentit.Nappula;

public class UlottuvuusPaneli
extends JPanel {
    private AsetuksetPaneli asetuksetPaneli;
    private Asetukset asetukset;
    private String fontinNimi;

    public UlottuvuusPaneli(AsetuksetPaneli asetuksetPaneli, Asetukset asetukset, String string) {
        this.asetuksetPaneli = asetuksetPaneli;
        this.asetukset = asetukset;
        this.fontinNimi = string;
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.luoUlottuvuusValinta("Leveys");
        this.luoUlottuvuusValinta("Korkeus");
        this.luoUlottuvuusValinta("Syvyys");
    }

    private void luoUlottuvuusValinta(String string) {
        this.luoOtsikko(string);
        this.luoNappula(string);
    }

    private void luoOtsikko(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font(this.fontinNimi, 0, 18));
        jLabel.setForeground(Color.WHITE);
        this.add(jLabel);
    }

    private void luoNappula(String string) {
        Nappula nappula = new Nappula(this.haeUlottuvuudenArvo(string));
        nappula.setFocusable(false);
        nappula.setEnabled(true);
        nappula.addActionListener(new UlottuvuusNappulaKuuntelija(string, nappula, this));
        this.add(nappula);
    }

    private String haeUlottuvuudenArvo(String string) {
        if (string.equals("Leveys")) {
            return this.asetukset.annaUlottuvuudet().annaLeveys() + "";
        }
        if (string.equals("Korkeus")) {
            return this.asetukset.annaUlottuvuudet().annaKorkeus() + "";
        }
        return this.asetukset.annaUlottuvuudet().annaSyvyys() + "";
    }

    public void muutaUlottuvuusNappuloidenAktiivisuuksia(boolean bl) {
        for (Component component : this.getComponents()) {
            if (!(component instanceof Nappula)) continue;
            Nappula nappula = (Nappula)component;
            nappula.setEnabled(bl);
        }
        this.repaint();
    }

    public void luoOikeaVaihtelevaPalsta(String string) {
        this.asetuksetPaneli.luoOikeaVaihtelevaPalsta(string);
    }

    public void asetaPyydettyArvo(int n) {
        for (Component component : this.getComponents()) {
            Nappula nappula;
            if (!(component instanceof Nappula) || !(nappula = (Nappula)component).getText().equals("")) continue;
            nappula.setText(n + "");
            break;
        }
        this.muutaUlottuvuusNappuloidenAktiivisuuksia(true);
    }

    private static class UlottuvuusNappulaKuuntelija
    implements ActionListener {
        private String aihe;
        private Nappula nappula;
        private UlottuvuusPaneli kohde;

        public UlottuvuusNappulaKuuntelija(String string, Nappula nappula, UlottuvuusPaneli ulottuvuusPaneli) {
            this.aihe = string;
            this.nappula = nappula;
            this.kohde = ulottuvuusPaneli;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.nappula.setText("");
            this.kohde.muutaUlottuvuusNappuloidenAktiivisuuksia(false);
            this.kohde.luoOikeaVaihtelevaPalsta(this.aihe);
        }
    }
}

