/*
 * Decompiled with CFR 0.152.
 */
package peli.asetukset.grafiikka;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import peli.asetukset.grafiikka.AsetuksetPaneli;
import peli.asetukset.logiikka.Asetukset;
import valmiskomponentit.Nappula;

public class VaihtelevaPaneli
extends JPanel {
    private AsetuksetPaneli asetuksetPaneli;
    private Asetukset asetukset;
    private String aihe;
    private String fontinNimi;

    public VaihtelevaPaneli(AsetuksetPaneli asetuksetPaneli, Asetukset asetukset, String string, String string2) {
        this.asetuksetPaneli = asetuksetPaneli;
        this.asetukset = asetukset;
        this.aihe = string;
        this.fontinNimi = string2;
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(false);
        this.luoOtsikko();
        this.luoNappulat();
    }

    private void luoOtsikko() {
        JLabel jLabel = new JLabel(this.aihe);
        jLabel.setFont(new Font(this.fontinNimi, 0, 18));
        jLabel.setForeground(Color.WHITE);
        this.add(jLabel);
    }

    private void luoNappulat() {
        int n = this.annaAiheenAlaraja();
        int n2 = this.annaAiheenYlaraja();
        for (int i = n; i <= n2; ++i) {
            if (this.aihe.equals("Taso")) {
                this.luoTasoNappula(i);
                continue;
            }
            this.luoUlottuvuusNappula(this.aihe, i);
        }
    }

    private int annaAiheenAlaraja() {
        if (this.aihe.equals("Leveys")) {
            return this.asetukset.annaUlottuvuudet().annaMinimiLeveys();
        }
        if (this.aihe.equals("Korkeus")) {
            return this.asetukset.annaUlottuvuudet().annaMinimiKorkeus();
        }
        if (this.aihe.equals("Syvyys")) {
            return this.asetukset.annaUlottuvuudet().annaMinimiSyvyys();
        }
        return this.asetukset.annaMinimitaso();
    }

    private int annaAiheenYlaraja() {
        if (this.aihe.equals("Leveys")) {
            return this.asetukset.annaUlottuvuudet().annaMaksimiLeveys();
        }
        if (this.aihe.equals("Korkeus")) {
            return this.asetukset.annaUlottuvuudet().annaMaksimiKorkeus();
        }
        if (this.aihe.equals("Syvyys")) {
            return this.asetukset.annaUlottuvuudet().annaMaksimiSyvyys();
        }
        return this.asetukset.annaMaksimitaso();
    }

    private void luoTasoNappula(int n) {
        Nappula nappula = new Nappula(n + "");
        nappula.setFont(new Font(this.fontinNimi, 0, 16));
        nappula.setFocusable(false);
        if (this.asetukset.annaAloitustaso() == n) {
            nappula.setEnabled(false);
        } else {
            nappula.setEnabled(true);
        }
        nappula.addActionListener(new TasoKuuntelija(this, n));
        this.add(nappula);
    }

    public void valitseTaso(int n) {
        this.asetukset.asetaAloitustaso(n);
        this.vaihdaTasoNappuloidenAktiivisuuksia(n);
    }

    private void vaihdaTasoNappuloidenAktiivisuuksia(int n) {
        for (Component component : this.getComponents()) {
            if (!(component instanceof Nappula)) continue;
            Nappula nappula = (Nappula)component;
            if (nappula.getText().equals(n + "")) {
                nappula.setEnabled(false);
                continue;
            }
            nappula.setEnabled(true);
        }
        this.repaint();
    }

    private void luoUlottuvuusNappula(String string, int n) {
        Nappula nappula = new Nappula(n + "");
        nappula.setFont(new Font(this.fontinNimi, 0, 16));
        nappula.setFocusable(false);
        nappula.setEnabled(true);
        nappula.addActionListener(new UlottuvuusKuuntelija(this, string, n));
        this.add(nappula);
    }

    public void valitseUlottuvuus(String string, int n) {
        if (string.equals("Leveys")) {
            this.asetukset.annaUlottuvuudet().asetaLeveys(n);
        } else if (string.equals("Korkeus")) {
            this.asetukset.annaUlottuvuudet().asetaKorkeus(n);
        } else if (string.equals("Syvyys")) {
            this.asetukset.annaUlottuvuudet().asetaSyvyys(n);
        }
        this.asetuksetPaneli.asetaVaihtelevaPalstaPerustilaan(n);
    }

    private static class UlottuvuusKuuntelija
    implements ActionListener {
        private VaihtelevaPaneli kohde;
        private String aihe;
        private int arvo;

        public UlottuvuusKuuntelija(VaihtelevaPaneli vaihtelevaPaneli, String string, int n) {
            this.kohde = vaihtelevaPaneli;
            this.aihe = string;
            this.arvo = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.kohde.valitseUlottuvuus(this.aihe, this.arvo);
        }
    }

    private static class TasoKuuntelija
    implements ActionListener {
        private VaihtelevaPaneli kohde;
        private int arvo;

        public TasoKuuntelija(VaihtelevaPaneli vaihtelevaPaneli, int n) {
            this.kohde = vaihtelevaPaneli;
            this.arvo = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.kohde.valitseTaso(this.arvo);
        }
    }
}

