/*
 * Decompiled with CFR 0.152.
 */
package peli.asetukset.logiikka;

import java.io.FileWriter;
import java.util.Scanner;
import peli.asetukset.PelinAsetukset;
import peli.asetukset.logiikka.Nappainsetti;
import peli.asetukset.logiikka.Ulottuvuudet;
import peli.asetukset.logiikka.Varit;
import peli.logiikka.Palikkasetti;

public class Asetukset {
    private PelinAsetukset pelinAsetukset;
    private String asetustenNimi;
    private Ulottuvuudet ulottuvuudet;
    private int aloitustaso;
    private Palikkasetti palikkasetti;
    private Nappainsetti nappainsetti;
    private Varit varit;
    private boolean aanetPaalla;

    public Asetukset(PelinAsetukset pelinAsetukset) {
        this.pelinAsetukset = pelinAsetukset;
        this.asetustenNimi = "";
        this.ulottuvuudet = new Ulottuvuudet(pelinAsetukset);
        this.aloitustaso = 0;
        this.palikkasetti = Palikkasetti.FLAT;
        this.nappainsetti = new Nappainsetti(pelinAsetukset);
        this.varit = new Varit();
        this.aanetPaalla = true;
    }

    public void avaaAsetukset(Scanner scanner) {
        this.asetaAsetustenNimi(scanner.nextLine());
        this.ulottuvuudet.avaaUlottuvuudet(scanner.nextLine());
        this.asetaAloitustaso(Integer.parseInt(scanner.nextLine()));
        this.avaaPalikkasetti(scanner.nextLine());
        this.nappainsetti.avaaNappainsetti(scanner.nextLine());
        boolean bl = this.varit.avaaVarit(scanner.nextLine());
        if (bl) {
            String[] stringArray = scanner.nextLine().split(" ");
            this.aanetPaalla = stringArray[0].equals("true");
        }
    }

    private void avaaPalikkasetti(String string) {
        if (string.equals("basic")) {
            this.asetaPalikkasetti(Palikkasetti.BASIC);
        } else if (string.equals("extended")) {
            this.asetaPalikkasetti(Palikkasetti.EXTENDED);
        }
    }

    public void tallennaAsetukset(FileWriter fileWriter) throws Exception {
        fileWriter.write(this.asetustenNimi + "\n");
        fileWriter.write(this.ulottuvuudet.tallennaUlottuvuudet() + "\n");
        fileWriter.write(this.aloitustaso + "\n");
        fileWriter.write(this.palikkasetti.annaNimi().toLowerCase() + "\n");
        fileWriter.write(this.nappainsetti.tallennaNappainsetti() + "\n");
        fileWriter.write(this.varit.tallennaVarit() + " ...\n");
        fileWriter.write(this.aanetPaalla + "\n");
    }

    public String annaAsetustenNimi() {
        return this.asetustenNimi;
    }

    public boolean asetaAsetustenNimi(String string) {
        this.asetustenNimi = string;
        this.pelinAsetukset.tallennaTallennokset();
        return true;
    }

    public Ulottuvuudet annaUlottuvuudet() {
        return this.ulottuvuudet;
    }

    public int annaAloitustaso() {
        return this.aloitustaso;
    }

    public int annaMinimitaso() {
        return 0;
    }

    public int annaMaksimitaso() {
        return 10;
    }

    public void asetaAloitustaso(int n) {
        if (n >= 0 && n <= 10) {
            this.aloitustaso = n;
            this.pelinAsetukset.tallennaTallennokset();
        }
    }

    public Palikkasetti annaPalikkasetti() {
        return this.palikkasetti;
    }

    public boolean asetaPalikkasetti(Palikkasetti palikkasetti) {
        this.palikkasetti = palikkasetti;
        this.pelinAsetukset.tallennaTallennokset();
        return true;
    }

    public Nappainsetti annaNappainsetti() {
        return this.nappainsetti;
    }

    public Varit annaVarit() {
        return this.varit;
    }

    public boolean annaAanet() {
        return this.aanetPaalla;
    }

    public boolean asetaAanet(boolean bl) {
        this.aanetPaalla = bl;
        this.pelinAsetukset.tallennaTallennokset();
        return true;
    }
}

