/*
 * Decompiled with CFR 0.152.
 */
package peli.ennatyslista;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import peli.ennatyslista.Ennatyslistat;
import peli.ennatyslista.NappainKuuntelija;
import peli.ennatyslista.Saatopaneli;
import peli.logiikka.Palikkasetti;
import valmiskomponentit.Ikkuna;
import valmiskomponentit.Nappula;

public class Ennatyslistaaja
extends Ikkuna {
    private Ennatyslistat ennatyslistat = new Ennatyslistat("ennatyslistat.javafile");
    private int valittuPienempiLeveys = 5;
    private int valittuSuurempiLeveys = 5;
    private int valittuSyvyys = 10;
    private Palikkasetti valittuPalikkasetti = Palikkasetti.FLAT;
    private boolean yleinenListaNakyvissa = false;
    private boolean kysytaanNimea = false;
    private int lisattavanPisteet = -1;
    private String lisattavanNimi = "";
    private JPanel listapaneli;
    private JPanel valikkopaneli;
    private JPanel nimipaneli;
    private Saatopaneli saatopaneli;

    public Ennatyslistaaja() {
        this.luoJPanelinSisalto();
        this.addKeyListener(new NappainKuuntelija(this));
    }

    private void luoJPanelinSisalto() {
        this.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("-");
        jLabel.setOpaque(false);
        this.add((Component)jLabel, "South");
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setOpaque(false);
        this.add((Component)jPanel, "Center");
        this.listapaneli = new JPanel(new BorderLayout());
        this.listapaneli.setOpaque(false);
        jPanel.add(this.listapaneli);
        this.luoListapanelinSisalto();
        this.valikkopaneli = new JPanel(new GridLayout(2, 1));
        this.valikkopaneli.setOpaque(false);
        jPanel.add(this.valikkopaneli);
        this.luoValikkopanelinSisalto();
    }

    private void luoListapanelinSisalto() {
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.setOpaque(false);
        Nappula nappula = new Nappula("Kuilukohtainen");
        nappula.setEnabled(false);
        nappula.setFocusable(false);
        nappula.setOpaque(false);
        nappula.addActionListener(new Listakuuntelija(this, jPanel));
        jPanel.add(nappula);
        Nappula nappula2 = new Nappula("Yleinen");
        nappula2.setEnabled(true);
        nappula2.setFocusable(false);
        nappula2.setOpaque(false);
        nappula2.addActionListener(new Listakuuntelija(this, jPanel));
        jPanel.add(nappula2);
        this.listapaneli.add((Component)jPanel, "South");
    }

    private void vaihdaNakyvaaListaa() {
        this.vaihdaNakyvaaListaa((JPanel)this.listapaneli.getComponent(0));
    }

    public void vaihdaNakyvaaListaa(JPanel jPanel) {
        this.yleinenListaNakyvissa = !this.yleinenListaNakyvissa;
        this.vaihdaListanappuloidenKlikattavuuksia(jPanel);
        this.repaint();
    }

    private void vaihdaListanappuloidenKlikattavuuksia(JPanel jPanel) {
        for (Component component : jPanel.getComponents()) {
            Nappula nappula;
            if (!(component instanceof Nappula)) continue;
            nappula.setEnabled(!(nappula = (Nappula)component).isEnabled());
        }
    }

    private void luoValikkopanelinSisalto() {
        this.nimipaneli = new JPanel();
        this.nimipaneli.setOpaque(false);
        this.valikkopaneli.add(this.nimipaneli);
        this.saatopaneli = new Saatopaneli(this);
        this.saatopaneli.setOpaque(false);
        this.valikkopaneli.add(this.saatopaneli);
    }

    public boolean paaseekoListalle(int n, int n2, int n3, int n4, Palikkasetti palikkasetti) {
        int n5 = Math.min(n2, n3);
        int n6 = Math.max(n2, n3);
        return this.ennatyslistat.paaseekoListalle(n, n5, n6, n4, palikkasetti);
    }

    public void poistaEnnatyslistanKysely() {
        this.kysytaanNimea = false;
        this.lisattavanPisteet = 0;
        this.lisattavanNimi = "";
        this.aktivoiSaatopanelinSisalto();
    }

    private void aktivoiSaatopanelinSisalto() {
    }

    private void passivoiSaatopanelinSisalto() {
    }

    public void annaEnnatyslistalleKasiteltavaksi(int n, int n2, int n3, int n4, Palikkasetti palikkasetti) {
        this.kysytaanNimea = true;
        this.lisattavanPisteet = n;
        this.lisattavanNimi = "";
        this.saadaEnnatyslistanParametrit(n2, n3, n4, palikkasetti);
        this.valitseKumpiEnnatyslista(n);
    }

    public void saadaEnnatyslistanParametrit(int n, int n2, int n3, Palikkasetti palikkasetti) {
        this.valittuPienempiLeveys = Math.min(n, n2);
        this.valittuSuurempiLeveys = Math.max(n, n2);
        this.valittuSyvyys = n3;
        this.valittuPalikkasetti = palikkasetti;
    }

    private void valitseKumpiEnnatyslista(int n) {
        if (this.ennatyslistat.paaseekoListalle(n, -1, -1, -1, Palikkasetti.VOID)) {
            if (!this.yleinenListaNakyvissa) {
                this.vaihdaNakyvaaListaa();
            }
        } else if (this.yleinenListaNakyvissa) {
            this.vaihdaNakyvaaListaa();
        }
    }

    public boolean kysytaankoNimea() {
        return this.kysytaanNimea;
    }

    public void vahvistaNimiJaLisaaListalle() {
        if (this.lisattavanNimi.length() > 0) {
            this.ennatyslistat.lisaaListalle(this.lisattavanPisteet, this.lisattavanNimi, this.valittuPienempiLeveys, this.valittuSuurempiLeveys, this.valittuSyvyys, this.valittuPalikkasetti);
            this.lisaaYleiselleListalle();
        }
        this.poistaEnnatyslistanKysely();
        this.paivita();
    }

    private void lisaaYleiselleListalle() {
        if (this.ennatyslistat.paaseekoListalle(this.lisattavanPisteet, -1, -1, -1, Palikkasetti.VOID)) {
            this.ennatyslistat.lisaaListalle(this.lisattavanPisteet, this.lisattavanNimi, -1, -1, -1, Palikkasetti.VOID);
        }
    }

    public int annaListaennatys(int n, int n2, int n3, Palikkasetti palikkasetti) {
        String string = this.ennatyslistat.annaListanSija(1, Math.min(n, n2), Math.max(n, n2), n3, palikkasetti);
        String[] stringArray = string.trim().split(" ");
        int n4 = Integer.parseInt(stringArray[0]);
        return n4;
    }

    public void poistaNimestaMerkki() {
        if (this.lisattavanNimi.length() > 0) {
            this.lisattavanNimi = this.lisattavanNimi.substring(0, this.lisattavanNimi.length() - 1);
            this.paivita();
        }
    }

    public void lisaaNimeenMerkki(String string) {
        if (this.lisattavanNimi.length() < 15) {
            this.lisattavanNimi = this.lisattavanNimi + string;
            this.paivita();
        }
    }

    private void paivita() {
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.piirraOtsikko(graphics);
        if (this.yleinenListaNakyvissa) {
            this.piirraYleisetListasijat(graphics);
        } else {
            this.piirraKuilukohtaisetListasijat(graphics);
        }
        if (this.kysytaanNimea) {
            this.piirraNimikysely(graphics);
        }
    }

    private void piirraOtsikko(Graphics graphics) {
        Font font = new Font(this.haeFontti(), 0, 30);
        graphics.setFont(font);
        graphics.setColor(Color.WHITE);
        graphics.drawString("Ennatyslista", 35, 80);
    }

    private void piirraKuilukohtaisetListasijat(Graphics graphics) {
        this.piirraListasijat(graphics, this.valittuPienempiLeveys, this.valittuSuurempiLeveys, this.valittuSyvyys, this.valittuPalikkasetti);
    }

    private void piirraYleisetListasijat(Graphics graphics) {
        this.piirraListasijat(graphics, -1, -1, -1, Palikkasetti.VOID);
    }

    private void piirraListasijat(Graphics graphics, int n, int n2, int n3, Palikkasetti palikkasetti) {
        Font font = new Font(this.haeFontti(), 0, 18);
        graphics.setFont(font);
        for (int i = 1; i <= this.ennatyslistat.annaListanSijojenMaara(); ++i) {
            String string = this.ennatyslistat.annaListanSija(i, n, n2, n3, palikkasetti);
            graphics.drawString(i + ":", 40, 100 + 30 * i);
            graphics.drawString(string, 70, 100 + 30 * i);
        }
    }

    private void piirraNimikysely(Graphics graphics) {
        Font font = new Font("herculanum", 0, 24);
        graphics.setFont(font);
        graphics.drawString("Nimesi:", this.getWidth() / 2, 120);
        Font font2 = new Font("herculanum", 0, 18);
        graphics.setFont(font2);
        graphics.drawString("_____________________________", this.getWidth() / 2, 150);
        graphics.drawString(this.lisattavanNimi, this.getWidth() / 2 + 10, 145);
        graphics.drawString("Pisteet: " + this.lisattavanPisteet, this.getWidth() / 2, 180);
    }

    private String haeFontti() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        String[] stringArray = new String[]{"Herculanum", "ComicSansMS", "Comic Sans MS", "ArialMT", "Arial"};
        for (String object : stringArray) {
            for (Font font : fontArray) {
                if (!font.getFontName().equals(object)) continue;
                return font.getFontName();
            }
        }
        for (Font font : fontArray) {
            if (!font.getFontName().toLowerCase().contains("arial")) continue;
            return font.getFontName();
        }
        return "futura";
    }

    private static class Listakuuntelija
    implements ActionListener {
        private Ennatyslistaaja ennatyslistaaja;
        private JPanel paneli;

        public Listakuuntelija(Ennatyslistaaja ennatyslistaaja, JPanel jPanel) {
            this.ennatyslistaaja = ennatyslistaaja;
            this.paneli = jPanel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.ennatyslistaaja.vaihdaNakyvaaListaa(this.paneli);
        }
    }
}

