/*
 * Decompiled with CFR 0.152.
 */
package peli.ennatyslista;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Scanner;
import peli.ennatyslista.Ennatyslista;
import peli.logiikka.Palikkasetti;

public class Ennatyslistat {
    private ArrayList<Ennatyslista> listat;
    private String listojenOsoite;
    private int listojenPituus;
    private boolean yleinenListaOlemassa;

    public Ennatyslistat(String string) {
        this.listojenOsoite = string;
        this.listojenPituus = 10;
        this.yleinenListaOlemassa = false;
        this.avaaListat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void avaaListat() {
        this.listat = new ArrayList();
        Scanner scanner = null;
        try {
            if (!this.tarkistaEnnatyslistanOikeellisuus(this.listojenOsoite)) {
                throw new Exception();
            }
            scanner = new Scanner(new File(this.listojenOsoite));
            int n = Integer.parseInt(scanner.nextLine());
            if (!scanner.nextLine().equals("")) {
                throw new Exception();
            }
            this.lueTiedostostaYksittaisetEnnatyslistat(scanner, n);
        }
        catch (IOException iOException) {
            this.listat = new ArrayList();
            System.out.println("Tiedoston 'ennatyslista' avaus ei onnistunut.");
            iOException.printStackTrace();
        }
        catch (NumberFormatException numberFormatException) {
            this.listat = new ArrayList();
            System.out.println("Tiedostoon 'ennatyslista' oli kajottu. (NumberFormatException)");
        }
        catch (Exception exception) {
            this.listat = new ArrayList();
            System.out.println("Tiedoston 'ennatyslista' oikeellisuutta ei voitu tarkistaa tai ennatyslistaan oli kajottu.");
            exception.printStackTrace();
        }
        finally {
            try {
                scanner.close();
            }
            catch (Exception exception) {}
        }
    }

    private void lueTiedostostaYksittaisetEnnatyslistat(Scanner scanner, int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            String string;
            int n2;
            int n3;
            String[] stringArray = scanner.nextLine().split(" ");
            int n4 = Integer.parseInt(stringArray[0]);
            if (!this.tallenteenMaareetSopivat(n4, n3 = Integer.parseInt(stringArray[1]), n2 = Integer.parseInt(stringArray[2]), string = stringArray[3])) {
                System.out.println("Enn\u00e4tyslistaan oli tallennettu kent\u00e4n tiedot v\u00e4\u00e4r\u00e4ss\u00e4 muodossa.");
                throw new Exception();
            }
            if (!scanner.nextLine().equals(":")) {
                throw new Exception();
            }
            Ennatyslista ennatyslista = new Ennatyslista(n4, n3, n2, string);
            ennatyslista.avaaLista(scanner);
            this.listat.add(ennatyslista);
        }
    }

    private boolean tallenteenMaareetSopivat(int n, int n2, int n3, String string) {
        if (!this.yleinenListaOlemassa && n == -1 && n2 == -1 && n3 == -1 && string.toLowerCase().equals("void")) {
            this.yleinenListaOlemassa = true;
            return true;
        }
        if (n > n2) {
            return false;
        }
        if (n < 3 || n > 7 || n2 < 3 || n2 > 7 || n3 < 6 || n3 > 18) {
            return false;
        }
        return string.toLowerCase().equals("flat") || string.toLowerCase().equals("basic") || string.toLowerCase().equals("extended");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tarkistaEnnatyslistanOikeellisuus(String string) throws Exception {
        boolean bl = true;
        Scanner scanner = null;
        try {
            scanner = new Scanner(new File(string));
            this.tarkistaOikeellisuusRiveittain(scanner, true);
        }
        catch (IOException iOException) {
            System.out.println("Tiedoston 'ennatyslista' avaus ei onnistunut kun yritettiin selvitt\u00e4\u00e4 enn\u00e4tyslistan oikeellisuutta.");
            iOException.printStackTrace();
            bl = false;
        }
        catch (PropertyVetoException propertyVetoException) {
            System.out.println("Tiedostoa 'ennatyslista' ei avattu, koska sen tarkistusrivi ei t\u00e4sm\u00e4nnyt tiedoston muuta sis\u00e4lt\u00f6\u00e4.");
            propertyVetoException.printStackTrace();
            bl = false;
        }
        catch (Exception exception) {
            System.out.println("Virhe oikeellisuuden tarkastuksessa, johon ei osattu varautua.");
            bl = false;
        }
        finally {
            try {
                scanner.close();
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    private String tarkistaOikeellisuusRiveittain(Scanner scanner, boolean bl) throws Exception {
        BigInteger bigInteger = BigInteger.ZERO;
        BigInteger bigInteger2 = BigInteger.ZERO;
        BigInteger bigInteger3 = BigInteger.ZERO;
        int n = 97;
        int n2 = 1;
        int n3 = 0;
        int n4 = 1;
        String string = "";
        while (scanner.hasNextLine()) {
            string = scanner.nextLine();
            if (!scanner.hasNextLine() && bl) break;
            for (int n5 : string.toCharArray()) {
                bigInteger = bigInteger.add(new BigInteger("" + n5 * n * n2));
                n = n5;
            }
            if (string.equals(":")) {
                n2 = 0;
            } else if (string.split(" ").length == 2) {
                int n6 = Integer.parseInt(string.split(" ")[0]);
                bigInteger2 = bigInteger2.add(new BigInteger("" + n6 % n4));
                if (n6 != 0) {
                    n3 = this.selvitaMoneskoMerkki(n3, n6);
                    bigInteger3 = bigInteger3.add(new BigInteger(("" + n6).charAt(n3) + ""));
                }
                ++n4;
            }
            ++n2;
        }
        Object object = bigInteger + " " + bigInteger2 + " " + bigInteger3;
        System.out.println((String)object);
        if (bl && !((String)object).equals(string)) {
            throw new PropertyVetoException("Tiedostoon oli kajottu.", new PropertyChangeEvent(this, "tarkistusrivi", object, string));
        }
        return object;
    }

    private int selvitaMoneskoMerkki(int n, int n2) {
        int n3 = n + 1;
        String string = "" + n2;
        if (string.length() - 1 >= n3) {
            return n3;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kirjoitaTarkistusrivi(String string) {
        OutputStreamWriter outputStreamWriter = null;
        Scanner scanner = null;
        try {
            scanner = new Scanner(new File(string));
            String string2 = this.tarkistaOikeellisuusRiveittain(scanner, false);
            System.out.println("Haluttu tarkistusrivi: " + string2);
            outputStreamWriter = new FileWriter(new File(string), true);
            outputStreamWriter.write("\n" + string2);
        }
        catch (Exception exception) {
            System.out.println("Tarkistusrivin kirjoituksessa meni jokin pieleen.");
            exception.printStackTrace();
        }
        finally {
            try {
                outputStreamWriter.close();
            }
            catch (Exception exception) {}
            try {
                scanner.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tallennaListat() {
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new FileWriter(new File(this.listojenOsoite));
            outputStreamWriter.write(this.listat.size() + "\n\n");
            this.tallennaKukinEnnatyslista((FileWriter)outputStreamWriter);
        }
        catch (Exception exception) {
            System.out.println("Tiedoston tallennus ei onnistunut");
            exception.printStackTrace();
        }
        finally {
            try {
                outputStreamWriter.close();
            }
            catch (Exception exception) {}
        }
        this.kirjoitaTarkistusrivi(this.listojenOsoite);
    }

    private void tallennaKukinEnnatyslista(FileWriter fileWriter) throws Exception {
        for (Ennatyslista ennatyslista : this.listat) {
            fileWriter.write(ennatyslista.annaPienempiLeveys() + " " + ennatyslista.annaSuurempiLeveys() + " " + ennatyslista.annaSyvyys() + " " + ennatyslista.annaPalikkasetti() + "\n");
            fileWriter.write(":\n");
            fileWriter.write(ennatyslista.tallennaLista());
        }
    }

    private Ennatyslista etsiOikeaEnnatyslista(int n, int n2, int n3, Palikkasetti palikkasetti) {
        for (Ennatyslista ennatyslista : this.listat) {
            if (!ennatyslista.onkoKokoJaSetti(n, n2, n3, palikkasetti.annaNimi())) continue;
            return ennatyslista;
        }
        Ennatyslista ennatyslista = new Ennatyslista(this.listojenPituus, n, n2, n3, palikkasetti.annaNimi());
        this.listat.add(ennatyslista);
        System.out.println("Luotu uusi ennatyslista talle koolle.");
        return ennatyslista;
    }

    public boolean paaseekoListalle(int n, int n2, int n3, int n4, Palikkasetti palikkasetti) {
        Ennatyslista ennatyslista = this.etsiOikeaEnnatyslista(n2, n3, n4, palikkasetti);
        return ennatyslista.paaseekoListalle(n);
    }

    public void lisaaListalle(int n, String string, int n2, int n3, int n4, Palikkasetti palikkasetti) {
        Ennatyslista ennatyslista = this.etsiOikeaEnnatyslista(n2, n3, n4, palikkasetti);
        ennatyslista.lisaaListalle(n, string);
        this.tallennaListat();
    }

    public int annaListanSijojenMaara() {
        return this.listojenPituus;
    }

    public String annaListanSija(int n, int n2, int n3, int n4, Palikkasetti palikkasetti) {
        Ennatyslista ennatyslista = this.etsiOikeaEnnatyslista(n2, n3, n4, palikkasetti);
        return ennatyslista.annaListanSija(n);
    }
}

