/*
 * Decompiled with CFR 0.152.
 */
package peli.grafiikka;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.util.ArrayList;
import peli.Koordinaatti;
import peli.grafiikka.Piste3DHaku;
import peli.logiikka.Pala;

public class Palikkapiirturi {
    private Piste3DHaku piste;
    private ArrayList<Color> varit;
    private Color kerroksenVari;

    public Palikkapiirturi(Piste3DHaku piste3DHaku, ArrayList<Color> arrayList) {
        this.piste = piste3DHaku;
        this.varit = arrayList;
    }

    public void asetaUudetVarit(ArrayList<Color> arrayList) {
        this.varit = arrayList;
    }

    public void piirra(Graphics graphics, Pala[][][] palaArray) {
        int n = palaArray.length;
        int n2 = palaArray[0].length;
        int n3 = palaArray[0][0].length;
        int n4 = 1;
        for (int i = n3 - 2; i >= 0; --i) {
            this.valitseVariKerrokselle(n4);
            this.piirraKerroksenPalojenSivutahkotLaidoistaKeskelle(graphics, n, n2, i, palaArray);
            this.piirraKerroksenPalojenPaallitahkot(graphics, n, n2, i, palaArray);
            ++n4;
        }
    }

    private void valitseVariKerrokselle(int n) {
        while (n > this.varit.size()) {
            n -= this.varit.size();
        }
        this.kerroksenVari = this.varit.get(n - 1);
    }

    private void piirraKerroksenPalojenSivutahkotLaidoistaKeskelle(Graphics graphics, int n, int n2, int n3, Pala[][][] palaArray) {
        int n4 = 1;
        while ((double)n4 < (double)(n2 / 2) - 0.5) {
            this.piirraKerroksenPalojenSivutahkotSivulaidoistaKeskelle(graphics, n, n4, n3, palaArray);
            ++n4;
        }
        n4 = n2 - 2;
        while ((double)n4 >= (double)(n2 / 2) - 0.5) {
            this.piirraKerroksenPalojenSivutahkotSivulaidoistaKeskelle(graphics, n, n4, n3, palaArray);
            --n4;
        }
    }

    private void piirraKerroksenPalojenSivutahkotSivulaidoistaKeskelle(Graphics graphics, int n, int n2, int n3, Pala[][][] palaArray) {
        int n4;
        for (n4 = n - 2; n4 > n / 2; --n4) {
            if (palaArray[n4][n2][n3] != Pala.VARATTU) continue;
            this.piirraSivutahkot(graphics, n4, n2, n3, n, palaArray[0].length);
        }
        for (n4 = 1; n4 <= n / 2; ++n4) {
            if (palaArray[n4][n2][n3] != Pala.VARATTU) continue;
            this.piirraSivutahkot(graphics, n4, n2, n3, n, palaArray[0].length);
        }
    }

    private void piirraKerroksenPalojenPaallitahkot(Graphics graphics, int n, int n2, int n3, Pala[][][] palaArray) {
        for (int i = 1; i < n2 - 1; ++i) {
            for (int j = 1; j < n - 1; ++j) {
                if (palaArray[j][i][n3] != Pala.VARATTU) continue;
                this.piirraTahko(graphics, j, i, n3, 0, 0, -1);
            }
        }
    }

    private void piirraSivutahkot(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if ((double)n < (double)n4 / 2.0) {
            this.piirraTahko(graphics, n, n2, n3, 1, 0, 0);
        } else {
            this.piirraTahko(graphics, n, n2, n3, -1, 0, 0);
        }
        if ((double)n2 < (double)n5 / 2.0 - 1.0) {
            this.piirraTahko(graphics, n, n2, n3, 0, 1, 0);
        } else if ((double)n2 >= (double)n5 / 2.0) {
            this.piirraTahko(graphics, n, n2, n3, 0, -1, 0);
        }
    }

    private void piirraTahko(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        ArrayList<Koordinaatti> arrayList = this.haeTahkonKulmat(n, n2, n3, n4, n5, n6);
        Polygon polygon = new Polygon();
        polygon.addPoint(arrayList.get(0).annaX(), arrayList.get(0).annaY());
        polygon.addPoint(arrayList.get(1).annaX(), arrayList.get(1).annaY());
        polygon.addPoint(arrayList.get(3).annaX(), arrayList.get(3).annaY());
        polygon.addPoint(arrayList.get(2).annaX(), arrayList.get(2).annaY());
        graphics.setColor(this.kerroksenVari);
        graphics.fillPolygon(polygon);
        graphics.setColor(Color.BLACK);
        graphics.drawPolygon(polygon);
    }

    private ArrayList<Koordinaatti> haeTahkonKulmat(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n4 != 0) {
            return this.haeTahkonVasemmanTaiOikeanPuolenKulmat(n, n2, n3, n4);
        }
        if (n5 != 0) {
            return this.haeTahkonYlaTaiAlapuolenKulmat(n, n2, n3, n5);
        }
        if (n6 != 0) {
            return this.haeTahkonEtuTaiTakapuolenKulmat(n, n2, n3, n6);
        }
        return null;
    }

    private ArrayList<Koordinaatti> haeTahkonVasemmanTaiOikeanPuolenKulmat(int n, int n2, int n3, int n4) {
        ArrayList<Koordinaatti> arrayList = new ArrayList<Koordinaatti>();
        for (int i = 1; i >= -1; i -= 2) {
            for (int j = -1; j <= 1; j += 2) {
                arrayList.add(this.piste.koordinaatit(n, n2, n3, n4, i, j));
            }
        }
        return arrayList;
    }

    private ArrayList<Koordinaatti> haeTahkonYlaTaiAlapuolenKulmat(int n, int n2, int n3, int n4) {
        ArrayList<Koordinaatti> arrayList = new ArrayList<Koordinaatti>();
        for (int i = 1; i >= -1; i -= 2) {
            for (int j = -1; j <= 1; j += 2) {
                arrayList.add(this.piste.koordinaatit(n, n2, n3, i, n4, j));
            }
        }
        return arrayList;
    }

    private ArrayList<Koordinaatti> haeTahkonEtuTaiTakapuolenKulmat(int n, int n2, int n3, int n4) {
        ArrayList<Koordinaatti> arrayList = new ArrayList<Koordinaatti>();
        for (int i = 1; i >= -1; i -= 2) {
            for (int j = 1; j >= -1; j -= 2) {
                arrayList.add(this.piste.koordinaatit(n, n2, n3, i, j, n4));
            }
        }
        return arrayList;
    }
}

