/*
 * Decompiled with CFR 0.152.
 */
package peli.grafiikka;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JPanel;
import peli.Peli;
import peli.asetukset.logiikka.Ulottuvuudet;
import peli.asetukset.logiikka.Varit;
import peli.ennatyslista.Ennatyslistaaja;
import peli.grafiikka.Palikkapiirturi;
import peli.grafiikka.Piste3DHaku;
import peli.grafiikka.Reunapiirturi;
import peli.grafiikka.Statistiikkapiirturi;
import peli.grafiikka.TippuvaPalikkapiirturi;
import peli.logiikka.Pala;
import peli.logiikka.Palikkasetti;
import peli.logiikka.Pistelaskija;
import peli.logiikka.TippuvaPalikka;

public class Piirturi {
    private Peli peli;
    private Piste3DHaku piste3DHaku;
    private Reunapiirturi reunapiirturi;
    private Palikkapiirturi palikkapiirturi;
    private TippuvaPalikkapiirturi tippuvaPalikkapiirturi;
    private Statistiikkapiirturi statistiikkapiirturi;
    private int ikkunanLeveys;
    private int ikkunanKorkeus;
    private int tietopalkinLeveys;

    public Piirturi(Peli peli, int n, int n2, Ulottuvuudet ulottuvuudet, Palikkasetti palikkasetti, Varit varit, Pistelaskija pistelaskija, Ennatyslistaaja ennatyslistaaja) {
        this.peli = peli;
        this.ikkunanLeveys = n;
        this.tietopalkinLeveys = 130;
        this.ikkunanKorkeus = n2;
        this.luoPiste3DHaku(ulottuvuudet);
        this.luoSisaisetPiirturit(varit, ulottuvuudet, pistelaskija, ennatyslistaaja);
    }

    private void luoPiste3DHaku(Ulottuvuudet ulottuvuudet) {
        int n = ulottuvuudet.annaLeveys();
        int n2 = ulottuvuudet.annaKorkeus();
        int n3 = ulottuvuudet.annaSyvyys();
        int n4 = ulottuvuudet.annaLeikkauspiste();
        this.piste3DHaku = new Piste3DHaku(this.ikkunanLeveys - this.tietopalkinLeveys * 2, this.tietopalkinLeveys, this.ikkunanKorkeus, n4, n, n2, n3);
    }

    private void luoSisaisetPiirturit(Varit varit, Ulottuvuudet ulottuvuudet, Pistelaskija pistelaskija, Ennatyslistaaja ennatyslistaaja) {
        this.reunapiirturi = new Reunapiirturi(this.piste3DHaku);
        this.palikkapiirturi = new Palikkapiirturi(this.piste3DHaku, varit.annaVarit());
        this.tippuvaPalikkapiirturi = new TippuvaPalikkapiirturi(this.piste3DHaku);
        this.statistiikkapiirturi = new Statistiikkapiirturi(this.tietopalkinLeveys, ulottuvuudet, varit, this.peli, pistelaskija, ennatyslistaaja);
    }

    public void asetaUudetAsetukset(int n, Varit varit) {
        this.palikkapiirturi.asetaUudetVarit(varit.annaVarit());
        this.statistiikkapiirturi.asetaUudetVarit(varit);
        this.piste3DHaku.asetaUusiLeikkauspiste(n);
    }

    public void paivita() {
        this.peli.paivita();
    }

    public void piirra(Graphics graphics, Pala[][][] palaArray, TippuvaPalikka tippuvaPalikka, int n) {
        this.reunapiirturi.piirra(graphics, palaArray);
        this.palikkapiirturi.piirra(graphics, palaArray);
        if (!this.peli.onkoTauolla()) {
            this.tippuvaPalikkapiirturi.piirra(graphics, tippuvaPalikka);
        }
        this.statistiikkapiirturi.piirra(graphics, this.ikkunanLeveys, this.ikkunanKorkeus, n);
    }

    public void piirraGameOver(Graphics graphics, JPanel jPanel, boolean bl) {
        int n = jPanel.getWidth();
        int n2 = jPanel.getHeight();
        graphics.setColor(Color.BLACK);
        Font font = new Font("futura", 0, 30);
        graphics.setFont(font);
        graphics.drawString("Game over", n / 5 * 2, n2 / 2);
        font = new Font("futura", 0, 14);
        graphics.setFont(font);
        graphics.drawString("Press any key.", n / 5 * 2 + 20, n2 / 2 + 30);
        if (bl) {
            this.piirraTato(graphics, jPanel, n, n2);
        }
    }

    private void piirraTato(Graphics graphics, JPanel jPanel, int n, int n2) {
        try {
            URL uRL = Piirturi.class.getResource("Tato.gif");
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            graphics.drawImage(image, n / 7 * 4, n2 / 3, jPanel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

