/*
 * Decompiled with CFR 0.152.
 */
package peli.grafiikka;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import peli.Peli;
import peli.asetukset.logiikka.Ulottuvuudet;
import peli.asetukset.logiikka.Varit;
import peli.ennatyslista.Ennatyslistaaja;
import peli.logiikka.Pistelaskija;

public class Statistiikkapiirturi {
    private Peli peli;
    private Pistelaskija pistelaskija;
    private ImageObserver kuvanSeuraaja;
    private Image oikeanLaidanKuva;
    private Image vasemmanLaidanKuva;
    private ArrayList<Color> varit;
    private int tietopalkinLeveys;
    private int kuilunLeveys;
    private int kuilunKorkeus;
    private int kuilunSyvyys;
    private int listaennatys;

    public Statistiikkapiirturi(int n, Ulottuvuudet ulottuvuudet, Varit varit, Peli peli, Pistelaskija pistelaskija, Ennatyslistaaja ennatyslistaaja) {
        this.peli = peli;
        this.pistelaskija = pistelaskija;
        this.kuvanSeuraaja = peli;
        this.avaaKuvat();
        this.varit = varit.annaVarit();
        this.tietopalkinLeveys = n;
        this.kuilunLeveys = ulottuvuudet.annaLeveys();
        this.kuilunKorkeus = ulottuvuudet.annaKorkeus();
        this.kuilunSyvyys = ulottuvuudet.annaSyvyys();
        this.listaennatys = ennatyslistaaja.annaListaennatys(this.kuilunLeveys, this.kuilunKorkeus, this.kuilunSyvyys, peli.annaPalikkasetti());
    }

    private void avaaKuvat() {
        URL uRL = Statistiikkapiirturi.class.getResource("OikeaLaita.png");
        this.oikeanLaidanKuva = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = Statistiikkapiirturi.class.getResource("VasenLaita.png");
        this.vasemmanLaidanKuva = Toolkit.getDefaultToolkit().getImage(uRL);
    }

    public void asetaUudetVarit(Varit varit) {
        this.varit = varit.annaVarit();
    }

    public void piirra(Graphics graphics, int n, int n2, int n3) {
        this.piirraVasenPalkki(graphics, 0, this.tietopalkinLeveys, n2, n3);
        this.piirraOikeaPalkki(graphics, n - this.tietopalkinLeveys, this.tietopalkinLeveys, n2);
    }

    private void piirraVasenPalkki(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawImage(this.vasemmanLaidanKuva, n + 6, 7, n2, n3 - 12, this.kuvanSeuraaja);
        graphics.setFont(new Font("futura", 0, 20));
        graphics.setColor(new Color(0, 255, 128));
        graphics.drawString("" + this.peli.annaTaso(), n + 6 + 60, 82);
        this.piirraPalojaSisaltavatKerrokset(graphics, n, n2, n3, n4);
    }

    private void piirraPalojaSisaltavatKerrokset(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 50;
        int n6 = 10;
        int n7 = 8;
        int n8 = (n2 - n5) / 2 + 20;
        int n9 = 40;
        this.piirraKerrosvalikonKehys(graphics, n, n8, n3, n9, n6, n7, n5);
        this.piirraKerrokset(graphics, n4, n, n8, n3, n9, n6, n7, n5);
    }

    private void piirraKerrosvalikonKehys(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = this.kuilunSyvyys * (n5 + n6) - n6 + 20;
        graphics.setColor(new Color(255, 0, 128));
        graphics.fillRoundRect(n + n2 - 10, n3 - n4 + n5 + 10 - n8, n7 + 20, n8, 5, 5);
        graphics.setColor(Color.BLACK);
        graphics.fillRoundRect(n + n2 - 10 + 4, n3 - n4 + n5 + 10 - n8, n7 + 20 - 8, n8, 5, 5);
    }

    private void piirraKerrokset(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = 0;
        block0: while (true) {
            Iterator<Color> iterator = this.varit.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                Color color = iterator.next();
                if (n9 >= n) {
                    return;
                }
                this.piirraKerroslaatta(graphics, n2 + n3, n4 - n5 - n9 * (n6 + n7), n8, n6, color);
                ++n9;
            }
            break;
        }
    }

    private void piirraKerroslaatta(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        graphics.setColor(new Color(76, 76, 76));
        graphics.fillRoundRect(n, n2, n3, n4, 5, 5);
        graphics.setColor(color);
        graphics.fillRoundRect(n + 2, n2 + 2, n3 - 4, n4 - 4, 5, 5);
    }

    private void piirraOikeaPalkki(Graphics graphics, int n, int n2, int n3) {
        graphics.drawImage(this.oikeanLaidanKuva, n - 6, 7, n2, n3 - 12, this.kuvanSeuraaja);
        graphics.setFont(new Font("futura", 0, 16));
        graphics.setColor(new Color(0, 255, 128));
        graphics.drawString("" + this.pistelaskija.annaPisteet(), n - 6 + 46, 84);
        graphics.drawString("" + this.peli.annaPelattujenPalojenMaara(), n - 6 + 65, 158);
        graphics.drawString("" + this.listaennatys, n - 6 + 37, 249);
        graphics.drawString("" + this.kuilunLeveys, n - 6 + 20, 377);
        graphics.drawString("" + this.kuilunKorkeus, n - 6 + 68, 352);
        graphics.drawString("" + this.kuilunSyvyys, n - 6 + 95, 409);
        String string = this.peli.annaPalikkasetti().annaNimi();
        graphics.drawString(string.toUpperCase(), n - 6 + 32, 462);
    }
}

