/*
 * Decompiled with CFR 0.152.
 */
package peli.logiikka;

import peli.Peli;
import peli.asetukset.logiikka.Ulottuvuudet;
import peli.logiikka.Pala;
import peli.logiikka.Palikka;
import peli.logiikka.Pistelaskija;

public class Kentta {
    private Peli peli;
    private Pistelaskija pistelaskija;
    private Pala[][][] kentta;
    private int leveys;
    private int korkeus;
    private int syvyys;

    public Kentta(Peli peli, Pistelaskija pistelaskija, Ulottuvuudet ulottuvuudet) {
        this.alustaKentta(ulottuvuudet);
        this.peli = peli;
        this.pistelaskija = pistelaskija;
    }

    private void alustaKentta(Ulottuvuudet ulottuvuudet) {
        this.leveys = ulottuvuudet.annaLeveys();
        this.korkeus = ulottuvuudet.annaKorkeus();
        this.syvyys = ulottuvuudet.annaSyvyys();
        this.kentta = new Pala[this.leveys + 2][this.korkeus + 2][this.syvyys + 1];
        for (int i = 0; i < this.syvyys + 1; ++i) {
            for (int j = 0; j < this.korkeus + 2; ++j) {
                for (int k = 0; k < this.leveys + 2; ++k) {
                    this.kentta[k][j][i] = i == this.syvyys + 1 - 1 || j == 0 || k == 0 || j == this.korkeus + 2 - 1 || k == this.leveys + 2 - 1 ? Pala.REUNA : Pala.TYHJA;
                }
            }
        }
    }

    public Pala[][][] annaKentta() {
        return this.kentta;
    }

    public int annaLeveys() {
        return this.leveys;
    }

    public int annaKorkeus() {
        return this.korkeus;
    }

    public int annaSyvyys() {
        return this.syvyys;
    }

    public boolean onkoKentanEdustaVapaana() {
        return this.kentta[(this.leveys + 2) / 2][(this.korkeus + 2) / 2][0] == Pala.TYHJA;
    }

    public void jahmetaPalikka(Palikka palikka, int n, int n2, int n3, int n4) {
        this.muutaPalatTippuvistaVaratuiksi(palikka, n, n2, n3);
        int n5 = this.tuhoaValmiitKerrokset();
        boolean bl = this.onkoKenttaTyhja();
        this.pistelaskija.annaPisteitaTiputuksesta(palikka, n4, n5, bl);
        this.peli.lisaaPelattujenPalojenMaaraa(palikka.annaPalojenMaara());
    }

    private void muutaPalatTippuvistaVaratuiksi(Palikka palikka, int n, int n2, int n3) {
        Pala[][][] palaArray = palikka.annaPalikka();
        int n4 = (palaArray.length - 1) / 2;
        for (int i = 0; i < palaArray[0][0].length; ++i) {
            for (int j = 0; j < palaArray[0].length; ++j) {
                for (int k = 0; k < palaArray.length; ++k) {
                    if (palaArray[k][j][i] != Pala.TIPPUVA || i - n4 + n3 < 0) continue;
                    this.kentta[k - n4 + n][j - n4 + n2][i - n4 + n3] = Pala.VARATTU;
                }
            }
        }
    }

    private int tuhoaValmiitKerrokset() {
        int n = 0;
        for (int i = 0; i <= this.syvyys - 1; ++i) {
            if (!this.kokoKerrosTaytetty(i)) continue;
            ++n;
            this.tiputaKerroksia(i);
        }
        return n;
    }

    private boolean kokoKerrosTaytetty(int n) {
        for (int i = 1; i < this.leveys + 1; ++i) {
            for (int j = 1; j < this.korkeus + 1; ++j) {
                if (this.kentta[i][j][n] == Pala.VARATTU) continue;
                return false;
            }
        }
        return true;
    }

    private void tiputaKerroksia(int n) {
        for (int i = n; i >= 0; --i) {
            for (int j = 1; j < this.leveys + 1; ++j) {
                for (int k = 1; k < this.korkeus + 1; ++k) {
                    this.kentta[j][k][i] = i == 0 ? Pala.TYHJA : this.kentta[j][k][i - 1];
                }
            }
        }
    }

    private boolean onkoKenttaTyhja() {
        for (int i = 0; i < this.syvyys; ++i) {
            for (int j = 1; j < this.korkeus + 1; ++j) {
                for (int k = 1; k < this.leveys + 1; ++k) {
                    if (this.kentta[k][j][i] == Pala.TYHJA) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean mahtuukoPalaKenttaan(int n, int n2, int n3) {
        try {
            return this.kentta[n][n2][n3] == Pala.TYHJA;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return n >= 1 && n2 >= 1 && n <= this.leveys && n2 <= this.korkeus;
        }
    }

    public int annaPalojaSisaltavienKerrostenMaara() {
        int n = 0;
        for (int i = this.syvyys - 1; i >= 0 && !this.kokoKerrosTyhja(i); --i) {
            ++n;
        }
        return n;
    }

    private boolean kokoKerrosTyhja(int n) {
        for (int i = 1; i < this.leveys + 1; ++i) {
            for (int j = 1; j < this.korkeus + 1; ++j) {
                if (this.kentta[i][j][n] != Pala.VARATTU) continue;
                return false;
            }
        }
        return true;
    }
}

