/*
 * Decompiled with CFR 0.152.
 */
package peli.logiikka;

import java.util.ArrayList;
import java.util.HashMap;
import peli.Koordinaatti;
import peli.logiikka.Kulmahaku;
import peli.logiikka.Pala;
import peli.logiikka.PalikkaPyorayttaja;

public class Palikka {
    private Pala[][][] palikka;
    private int koko;
    private int alapisteet;
    private int ylapisteet;
    private int palojenMaara;
    private HashMap<Koordinaatti, ArrayList<Koordinaatti>> sarmat;

    public Palikka(int n, int n2) {
        this(5, n, n2);
    }

    public Palikka(int n, int n2, int n3) {
        if (n % 2 == 0) {
            ++n;
        }
        this.koko = n;
        this.palikka = new Pala[this.koko][this.koko][this.koko];
        this.palikanTyhjaksiAlustus(this.palikka);
        this.alapisteet = n2;
        this.ylapisteet = n3;
        this.palojenMaara = 0;
        this.sarmat = new HashMap();
    }

    private void palikanTyhjaksiAlustus(Pala[][][] palaArray) {
        for (int i = 0; i < this.koko; ++i) {
            for (int j = 0; j < this.koko; ++j) {
                for (int k = 0; k < this.koko; ++k) {
                    palaArray[i][j][k] = Pala.TYHJA;
                }
            }
        }
    }

    public boolean lisaaPala(int n, int n2, int n3) {
        if (this.palikka[n - 1][n2 - 1][n3 - 1] == Pala.TIPPUVA) {
            return false;
        }
        this.palikka[n - 1][n2 - 1][n3 - 1] = Pala.TIPPUVA;
        ++this.palojenMaara;
        Kulmahaku kulmahaku = new Kulmahaku(this.palikka);
        this.sarmat = kulmahaku.haeSarmat();
        return true;
    }

    public Palikka kopioi() {
        Palikka palikka = new Palikka(this.koko, this.alapisteet, this.ylapisteet);
        for (int i = 0; i < this.koko; ++i) {
            for (int j = 0; j < this.koko; ++j) {
                for (int k = 0; k < this.koko; ++k) {
                    if (this.palikka[i][j][k] != Pala.TIPPUVA) continue;
                    palikka.lisaaPala(i + 1, j + 1, k + 1);
                }
            }
        }
        return palikka;
    }

    public Pala[][][] annaPalikka() {
        return this.palikka;
    }

    public int annaKeskipiste() {
        return (this.koko - 1) / 2;
    }

    public int annaLeveys() {
        int n = 0;
        for (int i = 0; i < this.koko; ++i) {
            if (!this.onkoTasossaPalikoita(i, i, 0, this.koko - 1, 0, this.koko - 1)) continue;
            ++n;
        }
        return n;
    }

    public int annaKorkeus() {
        int n = 0;
        for (int i = 0; i < this.koko; ++i) {
            if (!this.onkoTasossaPalikoita(0, this.koko - 1, i, i, 0, this.koko - 1)) continue;
            ++n;
        }
        return n;
    }

    private boolean onkoTasossaPalikoita(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                for (int k = n5; k <= n6; ++k) {
                    if (this.palikka[i][j][k] != Pala.TIPPUVA) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public int annaAlapisteet() {
        return this.alapisteet;
    }

    public int annaYlapisteet() {
        return this.ylapisteet;
    }

    public int annaPalojenMaara() {
        return this.palojenMaara;
    }

    public HashMap<Koordinaatti, ArrayList<Koordinaatti>> annaSuorat() {
        return this.sarmat;
    }

    public void pyoritaSuuntaEsille(int n, int n2) {
        Pala[][][] palaArray = new Pala[this.koko][this.koko][this.koko];
        this.palikanTyhjaksiAlustus(palaArray);
        PalikkaPyorayttaja palikkaPyorayttaja = new PalikkaPyorayttaja(this.palikka);
        this.palikka = palikkaPyorayttaja.pyoritaSuuntaEsille(palaArray, n, n2);
        Kulmahaku kulmahaku = new Kulmahaku(this.palikka);
        this.sarmat = kulmahaku.haeSarmat();
    }

    public void pyoritaMyotapaivaan(boolean bl) {
        Pala[][][] palaArray = new Pala[this.koko][this.koko][this.koko];
        this.palikanTyhjaksiAlustus(palaArray);
        PalikkaPyorayttaja palikkaPyorayttaja = new PalikkaPyorayttaja(this.palikka);
        this.palikka = palikkaPyorayttaja.pyoritaMyotapaivaan(palaArray, bl);
        Kulmahaku kulmahaku = new Kulmahaku(this.palikka);
        this.sarmat = kulmahaku.haeSarmat();
    }
}

