/*
 * Decompiled with CFR 0.152.
 */
package peli.logiikka;

import peli.Peli;
import peli.logiikka.Palikka;
import peli.logiikka.Palikkasetti;

public class Pistelaskija {
    private int pisteet = 0;
    private double[] palikkaTasokerroin = new double[]{0.06699, 0.139195, 0.2198, 0.308444, 0.403897, 0.507822, 0.619062, 0.73863, 0.865802, 1.0, 1.133333};
    private double[] kerrosTasokerroin = new double[]{0.096478, 0.163873, 0.242913, 0.328261, 0.422329, 0.518394, 0.630405, 0.747501, 0.867087, 1.0, 1.131653};
    private double[] kerrosmaarakerroin = new double[]{0.0, 1.0, 3.703372, 8.104827, 14.188325, 22.144941};
    private double[] syvyyskerroin = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.557692, 1.367521, 1.217949, 1.100427, 1.0, 0.918803, 0.852564, 0.788996, 0.737714, 0.691774, 0.651709, 0.61485, 0.583868};
    private Peli peli;
    private int kentanSyvyys;
    private Palikkasetti palikkasetti;

    public Pistelaskija(Peli peli, int n, Palikkasetti palikkasetti) {
        this.peli = peli;
        this.kentanSyvyys = n;
        this.palikkasetti = palikkasetti;
    }

    public int annaPisteet() {
        return this.pisteet;
    }

    public void annaPisteitaTiputuksesta(Palikka palikka, int n, int n2, boolean bl) {
        double d;
        double d2;
        double d3 = this.annaPisteitaPalikasta(palikka, n);
        int n3 = (int)((d3 + (d2 = this.annaPisteitaKerroksista(n2)) + (d = this.annaPisteitaTyhjennyksesta(bl))) * this.syvyyskerroin[this.kentanSyvyys]);
        if (n3 < 1) {
            n3 = 1;
        }
        this.pisteet += n3;
    }

    private double annaPisteitaPalikasta(Palikka palikka, int n) {
        double d = 1.0 * (double)n / (double)(this.kentanSyvyys - 1);
        double d2 = 1.0 * (double)palikka.annaAlapisteet();
        double d3 = 1.0 * (double)palikka.annaYlapisteet();
        return (d2 + (d3 - d2) * d) * this.palikkaTasokerroin[this.peli.annaTaso()];
    }

    private double annaPisteitaKerroksista(int n) {
        double d = 0.0;
        if (this.palikkasetti == Palikkasetti.FLAT) {
            d = 762.5;
        } else if (this.palikkasetti == Palikkasetti.BASIC) {
            d = 875.5;
        } else if (this.palikkasetti == Palikkasetti.EXTENDED) {
            d = 2886.25;
        }
        return d * this.kerrosTasokerroin[this.peli.annaTaso()] * this.kerrosmaarakerroin[n];
    }

    private double annaPisteitaTyhjennyksesta(boolean bl) {
        if (!bl) {
            return 0.0;
        }
        return this.annaPisteitaKerroksista(2);
    }
}

