/*
 * Decompiled with CFR 0.152.
 */
package peli.logiikka;

import peli.Peli;
import peli.logiikka.Kentta;
import peli.logiikka.Pala;
import peli.logiikka.Palikka;
import peli.logiikka.PyoritysAjastin;

public class TippuvaPalikka {
    private Palikka palikka;
    private int x;
    private int y;
    private int z;
    private int dAlfaXY;
    private int dAlfaYZ;
    private int dAlfaXZ;
    private Kentta kentta;
    private Peli peli;

    public TippuvaPalikka(Palikka palikka, Kentta kentta, Peli peli) {
        this.palikka = palikka;
        this.kentta = kentta;
        this.peli = peli;
        this.x = (kentta.annaLeveys() + 2) / 2;
        this.y = (kentta.annaKorkeus() + 2) / 2;
        this.z = 0;
        this.mahdutaPalikkaKenttaan();
        this.nollaaPyoritykset();
    }

    private void mahdutaPalikkaKenttaan() {
        this.mahdutaPyorayttamallaKenttaan();
        this.mahdutaSiirtamallaKenttaan();
    }

    private void mahdutaPyorayttamallaKenttaan() {
        if (this.palikka.annaLeveys() > this.kentta.annaLeveys() || this.palikka.annaKorkeus() > this.kentta.annaKorkeus()) {
            this.pyoritaSuuntaEsille(0, 1);
            if (this.mahtuukoPalikkaKenttaan(0, 0, 0)) {
                return;
            }
            this.pyoritaSuuntaEsille(1, 0);
            if (this.mahtuukoPalikkaKenttaan(0, 0, 0)) {
                return;
            }
        }
    }

    private void mahdutaSiirtamallaKenttaan() {
        if (!this.mahtuukoPalikkaKenttaan(0, 0, 0)) {
            if (this.siirra(-1, 0, 0)) {
                return;
            }
            if (this.siirra(-1, 1, 0)) {
                return;
            }
            System.out.println("Palikkaa ei saatu mahtumaan kenttaan. Ei pitaisi tapahtua jos kyseessa ei ole itse tehty palikka.");
        }
    }

    public int annaX() {
        return this.x;
    }

    public int annaY() {
        return this.y;
    }

    public int annaZ() {
        return this.z;
    }

    public Palikka annaPalikka() {
        return this.palikka;
    }

    public void siirra(int n, int n2) {
        this.siirra(n, n2, 0);
    }

    public boolean siirra(int n, int n2, int n3) {
        if (!this.mahtuukoPalikkaKenttaan(n, n2, n3)) {
            return false;
        }
        this.x += n;
        this.y += n2;
        this.z += n3;
        this.peli.paivita();
        return true;
    }

    public void tiputaPohjalle() {
        int n = 0;
        while (this.siirra(0, 0, 1)) {
            ++n;
        }
        this.kentta.jahmetaPalikka(this.palikka, this.x, this.y, this.z, n);
        this.peli.haeUusiPalikkaKenttaan();
    }

    public void oikaisePyoraytysta() {
        if (this.dAlfaXY != 0) {
            this.dAlfaXY += -10 * (this.dAlfaXY / Math.abs(this.dAlfaXY));
        }
        if (this.dAlfaYZ != 0) {
            this.dAlfaYZ += -10 * (this.dAlfaYZ / Math.abs(this.dAlfaYZ));
        }
        if (this.dAlfaXZ != 0) {
            this.dAlfaXZ += -10 * (this.dAlfaXZ / Math.abs(this.dAlfaXZ));
        }
        this.peli.paivita();
        if (this.dAlfaXY != 0 || this.dAlfaYZ != 0 || this.dAlfaXZ != 0) {
            new PyoritysAjastin(this.peli, this, 20);
        }
    }

    public int annaXYKulma() {
        return this.dAlfaXY;
    }

    public int annaYZKulma() {
        return this.dAlfaYZ;
    }

    public int annaXZKulma() {
        return this.dAlfaXZ;
    }

    public void nollaaPyoritykset() {
        this.dAlfaXY = 0;
        this.dAlfaYZ = 0;
        this.dAlfaXZ = 0;
    }

    public boolean pyoritaSuuntaEsille(int n, int n2) {
        this.palikka.pyoritaSuuntaEsille(n, n2);
        if (this.mahtuukoPalikkaKenttaan(0, 0, 0)) {
            this.selvitaPyorityksenAnimointi(n, n2);
            return true;
        }
        if (this.siirtelyMahdollistaaPyorityksen()) {
            this.selvitaPyorityksenAnimointi(n, n2);
            return true;
        }
        this.palikka.pyoritaSuuntaEsille(-n, -n2);
        return false;
    }

    private void selvitaPyorityksenAnimointi(int n, int n2) {
        if (n != 0) {
            this.dAlfaXZ += 90 * n;
        } else if (n2 != 0) {
            this.dAlfaYZ += -90 * n2;
        }
        this.peli.paivita();
        if (Math.abs(this.dAlfaXY) + Math.abs(this.dAlfaYZ) + Math.abs(this.dAlfaXZ) == 90) {
            new PyoritysAjastin(this.peli, this, 20);
        }
    }

    public boolean pyoritaMyotapaivaan(boolean bl) {
        this.palikka.pyoritaMyotapaivaan(bl);
        if (this.mahtuukoPalikkaKenttaan(0, 0, 0)) {
            this.selvitaPyorityksenAnimointi(bl);
            return true;
        }
        if (this.siirtelyMahdollistaaPyorityksen()) {
            this.selvitaPyorityksenAnimointi(bl);
            return true;
        }
        this.palikka.pyoritaMyotapaivaan(!bl);
        return false;
    }

    private void selvitaPyorityksenAnimointi(boolean bl) {
        this.dAlfaXY = bl ? (this.dAlfaXY += 90) : (this.dAlfaXY += -90);
        this.peli.paivita();
        if (Math.abs(this.dAlfaXY) + Math.abs(this.dAlfaYZ) + Math.abs(this.dAlfaXZ) == 90) {
            new PyoritysAjastin(this.peli, this, 20);
        }
    }

    private boolean siirtelyMahdollistaaPyorityksen() {
        if (this.yksinkertainenSiirtelyMahdollistaaPyorityksen()) {
            return true;
        }
        if (this.lyhytKulmasiirtelyMahdollistaaPyorityksen()) {
            return true;
        }
        return this.kahdenVerranSiirtelyMahdollistaaPyorityksen();
    }

    private boolean yksinkertainenSiirtelyMahdollistaaPyorityksen() {
        int n;
        for (n = -1; n <= 1; n += 2) {
            if (!this.mahtuukoPalikkaKenttaan(n, 0, 0)) continue;
            this.x += n;
            return true;
        }
        for (n = -1; n <= 1; n += 2) {
            if (!this.mahtuukoPalikkaKenttaan(0, n, 0)) continue;
            this.y += n;
            return true;
        }
        return false;
    }

    private boolean lyhytKulmasiirtelyMahdollistaaPyorityksen() {
        for (int i = -1; i <= 1; i += 2) {
            for (int j = -1; j <= 1; j += 2) {
                if (!this.mahtuukoPalikkaKenttaan(i, j, 0)) continue;
                this.x += i;
                this.y += j;
                return true;
            }
        }
        return false;
    }

    private boolean kahdenVerranSiirtelyMahdollistaaPyorityksen() {
        int n;
        for (n = -2; n <= 2; n += 4) {
            if (!this.mahtuukoPalikkaKenttaan(n, 0, 0)) continue;
            this.x += n;
            return true;
        }
        for (n = -2; n <= 2; n += 4) {
            if (!this.mahtuukoPalikkaKenttaan(0, n, 0)) continue;
            this.y += n;
            return true;
        }
        return false;
    }

    private boolean mahtuukoPalikkaKenttaan(int n, int n2, int n3) {
        Pala[][][] palaArray = this.palikka.annaPalikka();
        int n4 = this.palikka.annaKeskipiste();
        for (int i = 0; i < palaArray[0][0].length; ++i) {
            for (int j = 0; j < palaArray[0].length; ++j) {
                for (int k = 0; k < palaArray.length; ++k) {
                    if (palaArray[k][j][i] != Pala.TIPPUVA || this.kentta.mahtuukoPalaKenttaan(k - n4 + this.x + n, j - n4 + this.y + n2, i - n4 + this.z + n3)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

