/*
 * Decompiled with CFR 0.152.
 */
package valmiskomponentit;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Random;
import javax.swing.JButton;

public class Nappula
extends JButton {
    private Color tekstinVari;
    private Color taustanVari;
    private Color reunanVari;
    private Color tekstinVariAktiivisena;
    private Color taustanVariAktiivisena;
    private String fontinNimi;
    private int fontinKoko;
    private int nappulanKavennus;
    private int yvYlitys;
    private int yoYlitys;
    private int avYlitys;
    private int aoYlitys;
    private int vyYlitys;
    private int vaYlitys;
    private int oyYlitys;
    private int oaYlitys;

    public Nappula(String string) {
        this(string, Color.WHITE, Color.BLACK);
    }

    public Nappula(String string, Color color, Color color2) {
        super(string);
        this.setBorderPainted(false);
        this.tekstinVari = color;
        this.tekstinVariAktiivisena = color;
        this.taustanVari = color2;
        this.taustanVariAktiivisena = color2;
        this.reunanVari = Color.WHITE;
        this.fontinNimi = "futura";
        this.fontinKoko = 12;
        this.nappulanKavennus = 0;
        this.arvoNappulanReunojenYlitykset();
    }

    private void arvoNappulanReunojenYlitykset() {
        Random random = new Random();
        this.yvYlitys = random.nextInt(4) + 1;
        this.yoYlitys = random.nextInt(4) + 1;
        this.avYlitys = random.nextInt(4) + 1;
        this.aoYlitys = random.nextInt(4) + 1;
        this.vyYlitys = random.nextInt(4) + 1;
        this.vaYlitys = random.nextInt(4) + 1;
        this.oyYlitys = random.nextInt(4) + 1;
        this.oaYlitys = random.nextInt(4) + 1;
    }

    public void asetaTeksti(String string) {
        this.setText(string);
    }

    public void asetaFontti(String string, int n) {
        this.fontinNimi = string;
        this.fontinKoko = n;
    }

    public void asetaTekstinVari(Color color) {
        if (this.tekstinVariAktiivisena == this.tekstinVari) {
            this.tekstinVari = color;
        }
        this.tekstinVariAktiivisena = color;
    }

    public void asetaTaustanVari(Color color) {
        if (this.taustanVariAktiivisena == this.taustanVari) {
            this.taustanVari = color;
        }
        this.taustanVariAktiivisena = color;
        this.setBackground(color);
    }

    public void tummennaReuna(boolean bl) {
        this.reunanVari = bl ? Color.GRAY : Color.WHITE;
    }

    public void asetaNappulanKavennus(int n) {
        this.nappulanKavennus = n;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.tekstinVari = this.tekstinVariAktiivisena;
            this.taustanVari = this.taustanVariAktiivisena;
        } else {
            this.tekstinVari = this.tekstinVariAktiivisena.darker().darker();
            this.taustanVari = this.taustanVariAktiivisena.darker().darker();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.varitaTausta(graphics);
        this.varitaReunat(graphics);
        this.piirraTeksti(graphics);
    }

    private void varitaTausta(Graphics graphics) {
        graphics.setColor(Color.BLACK);
        graphics.fillRect(0 + this.nappulanKavennus, 0, this.getWidth() - 2 * this.nappulanKavennus, this.getHeight());
        graphics.setColor(this.taustanVari);
        graphics.fillRect(5 + this.nappulanKavennus, 5, this.getWidth() - 10 - this.nappulanKavennus * 2, this.getHeight() - 10);
    }

    private void varitaReunat(Graphics graphics) {
        graphics.setColor(this.reunanVari);
        Random random = new Random();
        int n = this.yvYlitys;
        int n2 = this.yoYlitys;
        graphics.drawRect(5 - n2 + this.nappulanKavennus, 5, this.getWidth() - 2 * this.nappulanKavennus - 10 + n + n2, 1);
        n = this.avYlitys;
        n2 = this.aoYlitys;
        graphics.drawRect(5 - n2 + this.nappulanKavennus, this.getHeight() - 5, this.getWidth() - 2 * this.nappulanKavennus - 10 + n + n2, 1);
        n = this.vyYlitys;
        n2 = this.vaYlitys;
        graphics.drawRect(this.nappulanKavennus + 5, 5 - n, 1, this.getHeight() - 10 + n + n2);
        n = this.oyYlitys;
        n2 = this.oaYlitys;
        graphics.drawRect(this.getWidth() - this.nappulanKavennus - 5, 5 - n, 1, this.getHeight() - 10 + n + n2);
    }

    private void piirraTeksti(Graphics graphics) {
        Font font = this.haeRuutuunSovitettuFontti(graphics);
        int n = this.laskeTekstinLeveys(graphics);
        int n2 = this.laskeTekstinKorkeus(graphics);
        int n3 = this.getWidth() - 2 * this.nappulanKavennus - 10;
        int n4 = (n3 - n) / 2;
        int n5 = this.getHeight() - 10;
        int n6 = (n5 - n2) / 2;
        graphics.setColor(this.tekstinVari);
        graphics.drawString(this.getText(), this.nappulanKavennus + 5 + n4, 5 + n6 + n2);
    }

    private Font haeRuutuunSovitettuFontti(Graphics graphics) {
        Font font;
        int n = 0;
        int n2 = this.fontinKoko;
        do {
            font = new Font(this.fontinNimi, 0, n2);
            graphics.setFont(font);
            n = this.laskeTekstinLeveys(graphics);
            --n2;
        } while (n > this.getWidth() - 2 * this.nappulanKavennus - 10 - 2);
        return font;
    }

    private int laskeTekstinLeveys(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        return fontMetrics.charsWidth(this.getText().toCharArray(), 0, this.getText().length());
    }

    private int laskeTekstinKorkeus(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        return fontMetrics.getMaxAscent();
    }
}

