/*
 * Decompiled with CFR 0.152.
 */
package varipaletti;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import peli.asetukset.PelinAsetukset;
import peli.asetukset.logiikka.Varit;
import valmiskomponentit.Nappula;

public class Varipaletti
extends JPanel
implements KeyListener {
    private PelinAsetukset pelinAsetukset;
    private Varit varit;
    private String fontinNimi;
    private JPanel kerrosValikoima;
    private JPanel variValikoima;
    private JPanel variTalletus;
    private int valittuKerros = 0;

    public Varipaletti(PelinAsetukset pelinAsetukset) {
        this.pelinAsetukset = pelinAsetukset;
        this.varit = pelinAsetukset.annaValitutAsetukset().annaVarit();
        this.haeFontti();
        this.luoKomponentit();
    }

    private void luoKomponentit() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.setOpaque(false);
        jPanel.setLayout(new GridLayout(1, 3));
        jPanel.setOpaque(false);
        jPanel.add(this.luoPaapalkki());
        this.variValikoima = new JPanel();
        this.variValikoima.setOpaque(false);
        jPanel.add(this.variValikoima);
        this.variTalletus = new JPanel();
        this.variTalletus.setOpaque(false);
        jPanel.add(this.variTalletus);
        this.add((Component)jPanel, "Center");
        this.add((Component)this.luoOtsikko(), "North");
        this.add((Component)new JLabel("-"), "South");
    }

    private JLabel luoOtsikko() {
        JLabel jLabel = new JLabel("V\u00e4riasetukset", 0);
        jLabel.setFont(new Font(this.fontinNimi, 0, 30));
        jLabel.setForeground(Color.WHITE);
        return jLabel;
    }

    private JPanel luoPaapalkki() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.kerrosValikoima = new JPanel();
        this.kerrosValikoima.setLayout(new FlowLayout());
        this.luoOlemassaOlevatKerrokset();
        jPanel.add((Component)this.kerrosValikoima, "Center");
        Nappula nappula = new Nappula("Palaa");
        nappula.setFocusable(false);
        nappula.addActionListener(new PaluuKuuntelija(this.pelinAsetukset));
        jPanel.add((Component)nappula, "South");
        return jPanel;
    }

    private void luoOlemassaOlevatKerrokset() {
        this.kerrosValikoima.removeAll();
        int n = 1;
        for (Color color : this.varit.annaVarit()) {
            JPanel jPanel = new JPanel(new GridLayout(1, 3));
            Nappula nappula = new Nappula(" " + n);
            nappula.setFocusable(false);
            nappula.asetaTekstinVari(Color.BLACK);
            nappula.asetaTaustanVari(color);
            nappula.setPreferredSize(new Dimension(50, 29));
            nappula.addActionListener(new KerrosKuuntelija(this, n));
            nappula.addActionListener(new MuutaVariKuuntelija(this, nappula));
            jPanel.add(nappula);
            Nappula nappula2 = new Nappula("Lis\u00e4\u00e4");
            nappula2.setFocusable(false);
            nappula2.setPreferredSize(new Dimension(50, 29));
            nappula2.addActionListener(new LisayksenKuuntelija(this, -n));
            jPanel.add(nappula2);
            Nappula nappula3 = new Nappula("Poista");
            nappula3.setFocusable(false);
            nappula3.setPreferredSize(new Dimension(50, 29));
            nappula3.addActionListener(new PoistonKuuntelija(this.pelinAsetukset, this, this.varit, n));
            jPanel.add(nappula3);
            this.kerrosValikoima.add(jPanel);
            ++n;
        }
    }

    public void valitseKerros(int n) {
        this.valittuKerros = n;
        int n2 = 1;
        for (Component component : this.kerrosValikoima.getComponents()) {
            if (!(component instanceof JPanel)) continue;
            JPanel jPanel = (JPanel)component;
            Nappula nappula = (Nappula)jPanel.getComponent(0);
            nappula.tummennaReuna(n2 == n);
            ++n2;
        }
        this.kerrosValikoima.repaint();
    }

    public void alustaVarikentat(Color color) {
        this.variValikoima.removeAll();
        this.alustaVariValikoima(color);
        this.variValikoima.revalidate();
    }

    private void alustaVariValikoima(Color color) {
        this.variValikoima.setLayout(new GridLayout(11, 6));
        int n = color.getBlue();
        int n2 = color.getGreen();
        int n3 = color.getRed();
        this.variValikoima.add(this.luoVariNappula(n3, n2, n));
        for (int n4 : this.haeVariarvot(n)) {
            for (int n5 : this.haeVariarvot(n2)) {
                for (int n6 : this.haeVariarvot(n3)) {
                    this.variValikoima.add(this.luoVariNappula(n6, n5, n4));
                }
            }
        }
        this.variValikoima.add(this.luoVariNappula(color.darker().getRed(), color.darker().getGreen(), color.darker().getBlue()));
    }

    private ArrayList<Integer> haeVariarvot(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(n / 2);
        arrayList.add(n * 3 / 4);
        arrayList.add(n + (255 - n) / 4);
        arrayList.add(n + (255 - n) / 2);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (n2 < 0) {
                n2 = 0;
                continue;
            }
            if (n2 <= 255) continue;
            n2 = 255;
        }
        return arrayList;
    }

    private Nappula luoVariNappula(int n, int n2, int n3) {
        Nappula nappula = new Nappula(" ");
        nappula.setFocusable(false);
        nappula.setFocusPainted(false);
        nappula.setBorderPainted(false);
        nappula.asetaTaustanVari(new Color(n, n2, n3));
        nappula.addActionListener(new MuutaVariKuuntelija(this, nappula));
        nappula.addActionListener(new ValitseVariKuuntelija(this, nappula));
        return nappula;
    }

    private void alustaTalletuskentta(Color color) {
        this.variTalletus.removeAll();
        this.variTalletus.setLayout(new GridLayout(3, 1));
        Nappula nappula = new Nappula(" ");
        nappula.setFocusable(false);
        nappula.asetaTaustanVari(new Color(color.getRed(), color.getGreen(), color.getBlue()));
        nappula.asetaNappulanKavennus(20);
        this.variTalletus.add(nappula);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        this.variTalletus.add(jPanel);
        Nappula nappula2 = new Nappula("Valitse v\u00e4ri");
        nappula2.setFocusable(false);
        nappula2.asetaNappulanKavennus(20);
        nappula2.addActionListener(new ValinnanKuuntelija(this, color));
        this.variTalletus.add(nappula2);
    }

    public void vaihdaKerroksenVari(Color color) {
        if (this.valittuKerros > 0) {
            this.varit.vaihdaVari(this.valittuKerros, color);
        } else if (this.valittuKerros < 0) {
            this.varit.lisaaVari(-this.valittuKerros, color);
        }
        this.pelinAsetukset.tallennaTallennokset();
        this.luoOlemassaOlevatKerrokset();
        this.revalidate();
    }

    public void tyhjennaVariKentat() {
        this.variValikoima.removeAll();
        this.variTalletus.removeAll();
        this.valittuKerros = 0;
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private void haeFontti() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        String[] stringArray = new String[]{"Herculanum", "ComicSansMS", "Comic Sans MS", "ArialMT", "Arial"};
        for (String object : stringArray) {
            for (Font font : fontArray) {
                if (!font.getFontName().equals(object)) continue;
                this.fontinNimi = font.getFontName();
                return;
            }
        }
        for (Font font : fontArray) {
            if (!font.getFontName().toLowerCase().contains("arial")) continue;
            this.fontinNimi = font.getFontName();
            return;
        }
        this.fontinNimi = "futura";
    }

    private static class ValinnanKuuntelija
    implements ActionListener {
        private Varipaletti paletti;
        private Color vari;

        public ValinnanKuuntelija(Varipaletti varipaletti, Color color) {
            this.paletti = varipaletti;
            this.vari = color;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.paletti.vaihdaKerroksenVari(this.vari);
            this.paletti.tyhjennaVariKentat();
        }
    }

    private static class PaluuKuuntelija
    implements ActionListener {
        private PelinAsetukset pelinAsetukset;

        public PaluuKuuntelija(PelinAsetukset pelinAsetukset) {
            this.pelinAsetukset = pelinAsetukset;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.pelinAsetukset.vaihdaAsetuksetPanelia();
            this.pelinAsetukset.revalidate();
        }
    }

    private static class LisayksenKuuntelija
    implements ActionListener {
        private Varipaletti paletti;
        private int kerros;

        public LisayksenKuuntelija(Varipaletti varipaletti, int n) {
            this.paletti = varipaletti;
            this.kerros = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.paletti.valitseKerros(this.kerros);
            this.paletti.alustaVarikentat(new Color(125, 125, 125));
        }
    }

    private static class PoistonKuuntelija
    implements ActionListener {
        private PelinAsetukset pelinAsetukset;
        private Varipaletti paletti;
        private Varit varit;
        private int kerros;

        public PoistonKuuntelija(PelinAsetukset pelinAsetukset, Varipaletti varipaletti, Varit varit, int n) {
            this.pelinAsetukset = pelinAsetukset;
            this.paletti = varipaletti;
            this.varit = varit;
            this.kerros = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.varit.poistaVari(this.kerros);
            this.pelinAsetukset.tallennaTallennokset();
            this.paletti.luoOlemassaOlevatKerrokset();
            this.paletti.tyhjennaVariKentat();
            this.paletti.revalidate();
            this.paletti.repaint();
        }
    }

    private static class ValitseVariKuuntelija
    implements ActionListener {
        private Varipaletti paletti;
        private Nappula nappula;

        public ValitseVariKuuntelija(Varipaletti varipaletti, Nappula nappula) {
            this.paletti = varipaletti;
            this.nappula = nappula;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.paletti.alustaTalletuskentta(this.nappula.getBackground());
        }
    }

    private static class MuutaVariKuuntelija
    implements ActionListener {
        private Varipaletti paletti;
        private Nappula nappula;

        public MuutaVariKuuntelija(Varipaletti varipaletti, Nappula nappula) {
            this.paletti = varipaletti;
            this.nappula = nappula;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.paletti.alustaVarikentat(this.nappula.getBackground());
        }
    }

    private static class KerrosKuuntelija
    implements ActionListener {
        private Varipaletti paletti;
        private int kerros;

        public KerrosKuuntelija(Varipaletti varipaletti, int n) {
            this.paletti = varipaletti;
            this.kerros = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.paletti.valitseKerros(this.kerros);
        }
    }
}

