#!/usr/bin/env python

from distutils.core import setup, Extension
import os
import sys

if not (sys.platform == 'darwin') or \
   not os.path.exists('/System/Library/PrivateFrameworks/readline.framework'):
	print "no point running this on a system other than OS X w/Aug dev tools."
	sys.exit(1)

try:
    setup (name = "readline",
           description = "readline package for OS X python",
           author = "readline.c came straight from Python 2.2.1 source",
           author_email = "bbum@codefab.com",
	   url = "http://www.python.org",
           ext_modules = [
	    Extension("readline",
		      ["readline.c"],
		   extra_compile_args=[
			"-g",
			"-O0",
			"-DMACOSX",
			"-I.",
			"-F/System/Library/PrivateFrameworks/"
		   ],
		   extra_link_args=[
			'-g',
			'-F/System/Library/PrivateFrameworks/',
			'-framework',
			'readline'
		   ])
	    ]
           )

except:
    import sys
    import traceback
    traceback.print_exc()
