/*
 * Decompiled with CFR 0.152.
 */
package Miinaharava;

import Miinaharava.HighScoreIO;
import Miinaharava.Tile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;

public class GameArea
extends JPanel
implements MouseListener {
    public static final int EASY = 1;
    public static final int MEDIUM = 2;
    public static final int HARD = 3;
    public static final int MINXTILES = 2;
    public static final int MAXXTILES = 50;
    public static final int MINYTILES = 2;
    public static final int MAXYTILES = 50;
    public static final int MAXDENSITY = 50;
    private int difficulty;
    private int xtiles;
    private int ytiles;
    private int minecount;
    private int minesRemaining;
    private int tilesRemaining;
    private boolean firstMove = true;
    private Tile[][] mineField;
    private JLabel time;
    private JLabel mines;
    private Timer timer = new Timer(1000, new TimeListener());

    private void setXTiles(int x) {
        if (x > 50) {
            this.xtiles = 50;
        }
        this.xtiles = x < 2 ? 2 : x;
    }

    private void setYTiles(int y) {
        if (y > 50) {
            this.ytiles = 50;
        }
        this.ytiles = y < 2 ? 2 : y;
    }

    private void setMinecount(int count) {
        int maxmines = 50 * this.xtiles * this.ytiles / 100;
        this.minecount = count > maxmines ? maxmines : (count < 1 ? 1 : count);
    }

    public int getXTiles() {
        return this.xtiles;
    }

    public int getYTiles() {
        return this.ytiles;
    }

    public int getMinecount() {
        return this.minecount;
    }

    public int getMinesRemaining() {
        return this.minesRemaining;
    }

    public int getTilesRemaining() {
        return this.tilesRemaining;
    }

    public GameArea(int width, int height, int count, int diff) {
        super(new BorderLayout());
        this.setXTiles(width);
        this.setYTiles(height);
        this.setMinecount(count);
        this.difficulty = diff;
        this.minesRemaining = this.getMinecount();
        this.tilesRemaining = this.getXTiles() * this.getYTiles();
        this.mineField = new Tile[this.xtiles][this.ytiles];
        JPanel panel = new JPanel(new FlowLayout());
        this.add((Component)panel, "Center");
        JPanel area = new JPanel(new GridLayout(this.xtiles, this.ytiles));
        for (int i = 0; i < this.xtiles; ++i) {
            for (int j = 0; j < this.ytiles; ++j) {
                this.mineField[i][j] = new Tile(i, j);
                this.mineField[i][j].addMouseListener(this);
                area.add(this.mineField[i][j]);
            }
        }
        panel.add(area);
        JPanel status = this.createInfoPane();
        this.add((Component)status, "South");
    }

    private JPanel createInfoPane() {
        JPanel panel = new JPanel(new FlowLayout());
        panel.setOpaque(true);
        panel.setBorder(BorderFactory.createEmptyBorder());
        this.time = new JLabel("0");
        this.time.setHorizontalAlignment(0);
        this.time.setPreferredSize(new Dimension(70, 50));
        this.time.setBorder(BorderFactory.createTitledBorder(new BevelBorder(0), "Aika", 2, 2));
        panel.add(this.time);
        JPanel padding = new JPanel();
        padding.setPreferredSize(new Dimension(40, 50));
        panel.add(padding);
        this.mines = new JLabel("0");
        this.mines.setHorizontalAlignment(0);
        this.mines.setPreferredSize(new Dimension(70, 50));
        this.mines.setBorder(BorderFactory.createTitledBorder(new BevelBorder(0), "Miinat", 2, 2));
        this.mines.setText(Integer.toString(this.getMinesRemaining()));
        panel.add(this.mines);
        return panel;
    }

    private int countAdjacentMines(Tile tile) {
        int nearmines = 0;
        int a = tile.getx();
        int b = tile.gety();
        for (int i = a - 1; i <= a + 1; ++i) {
            for (int j = b - 1; j <= b + 1; ++j) {
                if (i < 0 || i >= this.getXTiles() || j < 0 || j >= this.getYTiles() || !this.mineField[i][j].isMined()) continue;
                ++nearmines;
            }
        }
        return nearmines;
    }

    private int countAdjacentFlags(Tile tile) {
        int nearflags = 0;
        int a = tile.getx();
        int b = tile.gety();
        for (int i = a - 1; i <= a + 1; ++i) {
            for (int j = b - 1; j <= b + 1; ++j) {
                if (i < 0 || i >= this.getXTiles() || j < 0 || j >= this.getYTiles() || !this.mineField[i][j].isFlagged()) continue;
                ++nearflags;
            }
        }
        return nearflags;
    }

    private void revealAll() {
        for (int i = 0; i < this.getXTiles(); ++i) {
            for (int j = 0; j < this.getYTiles(); ++j) {
                if (!this.mineField[i][j].isEnabled()) continue;
                this.mineField[i][j].revealFull();
            }
        }
    }

    private void revealAdjacentTiles(Tile tile) {
        int a = tile.getx();
        int b = tile.gety();
        for (int i = a - 1; i <= a + 1; ++i) {
            for (int j = b - 1; j <= b + 1; ++j) {
                if (i < 0 || i >= this.getXTiles() || j < 0 || j >= this.getYTiles() || this.mineField[i][j].isRevealed() || this.mineField[i][j].isFlagged()) continue;
                if (this.mineField[i][j].isMined()) {
                    this.setLost();
                    continue;
                }
                this.mineField[i][j].reveal();
                --this.tilesRemaining;
                if (this.mineField[i][j].getAdjacentMines() != 0) continue;
                this.revealAdjacentTiles(this.mineField[i][j]);
            }
        }
    }

    private void layMines(Tile tile) {
        int j;
        int i;
        int minesLaid = 0;
        while (minesLaid < this.getMinecount()) {
            i = (int)((double)this.getXTiles() * Math.random());
            j = (int)((double)this.getYTiles() * Math.random());
            if (tile.getx() == i && tile.gety() == j || this.mineField[i][j].isMined()) continue;
            this.mineField[i][j].setMined(true);
            ++minesLaid;
        }
        for (i = 0; i < this.getXTiles(); ++i) {
            for (j = 0; j < this.getYTiles(); ++j) {
                this.mineField[i][j].setAdjacentMines(this.countAdjacentMines(this.mineField[i][j]));
            }
        }
        this.firstMove = false;
    }

    private void checkWin() {
        if (this.getMinesRemaining() == 0 && this.getTilesRemaining() == this.getMinecount()) {
            this.setWon();
        }
    }

    private void setLost() {
        this.timer.stop();
        System.out.println("H\u00e4visit!");
        this.revealAll();
    }

    private void setWon() {
        this.timer.stop();
        System.out.println("Voitit!");
        this.revealAll();
        if (this.difficulty == 1 || this.difficulty == 2 || this.difficulty == 3) {
            HighScoreIO reader = new HighScoreIO();
            reader.readValues();
            int bestTime = -1;
            int timeUsed = Integer.parseInt(this.time.getText());
            try {
                bestTime = Integer.parseInt(reader.getTime(this.difficulty));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (bestTime > 0 && timeUsed < bestTime) {
                reader.setTime(this.difficulty, Integer.toString(timeUsed));
                reader.writeValues();
                HighScoreInputWindow scoreinput = new HighScoreInputWindow();
                scoreinput.createHighScoreInputWindow();
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        Tile tile = (Tile)e.getSource();
        if (e.getButton() == 1) {
            if (this.firstMove) {
                this.layMines(tile);
                this.timer.start();
            }
            if (tile.isEnabled() && !tile.isFlagged()) {
                if (tile.isMined()) {
                    this.setLost();
                } else {
                    tile.reveal();
                    --this.tilesRemaining;
                    if (tile.getAdjacentMines() == 0) {
                        this.revealAdjacentTiles(tile);
                    }
                    this.checkWin();
                }
            }
        }
        if (e.getButton() == 2 && !this.firstMove && !tile.isFlagged()) {
            int mines;
            int flags = this.countAdjacentFlags(tile);
            if (flags == (mines = tile.getAdjacentMines())) {
                this.revealAdjacentTiles(tile);
            }
            this.checkWin();
        }
        if (e.getButton() == 3 && !this.firstMove && tile.isEnabled()) {
            if (tile.isFlagged()) {
                tile.setFlagged(false);
                ++this.minesRemaining;
                this.mines.setText(Integer.toString(this.getMinesRemaining()));
            } else {
                tile.setFlagged(true);
                --this.minesRemaining;
                this.mines.setText(Integer.toString(this.getMinesRemaining()));
                this.checkWin();
            }
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    class HighScoreInputWindow
    extends JDialog
    implements ActionListener {
        private HighScoreIO writer = new HighScoreIO();
        private JTextField name;

        HighScoreInputWindow() {
        }

        private Container createContentPane() {
            JPanel contentPane = new JPanel(new BorderLayout());
            contentPane.setOpaque(true);
            contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel center = new JPanel(new GridLayout(3, 1));
            contentPane.add((Component)center, "Center");
            JLabel message = new JLabel("Saavutit parhaan tuloksen!");
            center.add(message);
            message = new JLabel("Anna nimesi:");
            center.add(message);
            JPanel namepanel = new JPanel();
            namepanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            center.add(namepanel);
            this.name = new JTextField(15);
            this.name.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            namepanel.add(this.name);
            JPanel bottom = new JPanel(new FlowLayout());
            contentPane.add((Component)bottom, "South");
            JButton ok = new JButton("OK");
            ok.setActionCommand("close");
            ok.addActionListener(this);
            ok.setFocusPainted(false);
            bottom.add(ok);
            return contentPane;
        }

        public void actionPerformed(ActionEvent e) {
            JButton source = (JButton)e.getSource();
            String command = source.getActionCommand();
            if (command.equals("close")) {
                String newName = "";
                try {
                    newName = this.name.getText();
                }
                catch (NullPointerException ex) {
                    // empty catch block
                }
                if (newName.length() == 0) {
                    newName = "Nimet\u00f6n";
                }
                this.writer.readValues();
                this.writer.setName(GameArea.this.difficulty, newName);
                this.writer.writeValues();
                Container window = source.getTopLevelAncestor();
                window.setVisible(false);
            }
        }

        public void createHighScoreInputWindow() {
            JDialog newhigh = new JDialog(this, "Uusi paras tulos", true);
            newhigh.setDefaultCloseOperation(0);
            newhigh.setContentPane(this.createContentPane());
            newhigh.pack();
            newhigh.setLocationRelativeTo(this);
            newhigh.setResizable(false);
            newhigh.setVisible(true);
        }
    }

    class TimeListener
    implements ActionListener {
        TimeListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int newTime = Integer.parseInt(GameArea.this.time.getText()) + 1;
            GameArea.this.time.setText(Integer.toString(newTime));
        }
    }
}

