/*
 * Decompiled with CFR 0.152.
 */
package Miinaharava;

import Miinaharava.GameArea;
import Miinaharava.HighScoreIO;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;

public class HaravaGUI
extends JFrame
implements ActionListener {
    private JPanel contentPane;
    private JMenuBar menuBar;
    private GameArea gameArea;
    private int gameAreaWidth = 9;
    private int gameAreaHeight = 9;
    private int minecount = 10;
    private int difficulty = 1;

    private void saveSettings(int width, int height, int minecount, int diff) {
        this.gameAreaWidth = width;
        this.gameAreaHeight = height;
        this.minecount = minecount;
        this.difficulty = diff;
    }

    private JMenuBar createMenuBar() {
        this.menuBar = new JMenuBar();
        JMenu menu = new JMenu("Peli");
        menu.setMnemonic(80);
        this.menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Uusi");
        menuItem.setActionCommand("new");
        menuItem.setMnemonic(85);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Parhaat tulokset");
        menuItem.setActionCommand("highscore");
        menuItem.setMnemonic(80);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Asetukset");
        menuItem.setActionCommand("settings");
        menuItem.setMnemonic(65);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Lopeta");
        menuItem.setActionCommand("quit");
        menuItem.setMnemonic(76);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        this.menuBar.add(menu);
        menu = new JMenu("Ohje");
        menu.setMnemonic(79);
        menuItem = new JMenuItem("S\u00e4\u00e4nn\u00f6t");
        menuItem.setActionCommand("rules");
        menuItem.setMnemonic(83);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        this.menuBar.add(menu);
        return this.menuBar;
    }

    private Container createContentPane() {
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setOpaque(true);
        this.gameArea = new GameArea(this.gameAreaWidth, this.gameAreaHeight, this.minecount, this.difficulty);
        this.contentPane.add((Component)this.gameArea, "Center");
        return this.contentPane;
    }

    private void createGameArea() {
        JFrame frame = (JFrame)this.contentPane.getTopLevelAncestor();
        this.contentPane.remove(this.gameArea);
        this.gameArea = new GameArea(this.gameAreaWidth, this.gameAreaHeight, this.minecount, this.difficulty);
        this.contentPane.add((Component)this.gameArea, "Center");
        frame.pack();
        frame.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        String command = source.getActionCommand();
        if (command.equals("quit")) {
            System.exit(0);
        }
        if (command.equals("new")) {
            this.createGameArea();
        }
        if (command.equals("highscore")) {
            HighScoreWindow scores = new HighScoreWindow();
            scores.createHighScoreWindow();
        }
        if (command.equals("settings")) {
            SettingsWindow settings = new SettingsWindow();
            settings.createSettingsWindow();
        }
        if (command.equals("rules")) {
            HelpWindow help = new HelpWindow();
            help.createHelpWindow();
        }
    }

    private static void createAndShowGUI() {
        HaravaGUI frame = new HaravaGUI();
        frame.setTitle("JMiinaharava");
        frame.setDefaultCloseOperation(3);
        frame.setJMenuBar(frame.createMenuBar());
        frame.setContentPane(frame.createContentPane());
        frame.pack();
        frame.setResizable(false);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HaravaGUI.createAndShowGUI();
            }
        });
    }

    class HelpWindow
    extends JDialog {
        HelpWindow() {
        }

        private Container createContentPane() {
            JPanel contentPane = new JPanel(new BorderLayout());
            contentPane.setOpaque(true);
            JTextArea output = new JTextArea(40, 80);
            output.setEditable(false);
            output.setFont(new Font("Courier new", 0, 14));
            try {
                Scanner source = new Scanner(new File("readme.txt"));
                while (source.hasNextLine()) {
                    output.append(source.nextLine());
                    output.append("\n");
                }
                source.close();
            }
            catch (FileNotFoundException e) {
                System.err.println("Error: File \"readme.txt\" could not be found.");
                output.append("Helpfile not found.");
            }
            JScrollPane scrollPane = new JScrollPane(output);
            contentPane.add(scrollPane);
            return contentPane;
        }

        public void createHelpWindow() {
            JDialog help = new JDialog(this, "S\u00e4\u00e4nn\u00f6t", true);
            help.setDefaultCloseOperation(1);
            help.setContentPane(this.createContentPane());
            help.pack();
            help.setLocationRelativeTo(this);
            help.setResizable(true);
            help.setVisible(true);
        }
    }

    class SettingsWindow
    extends JDialog
    implements ActionListener {
        private JRadioButton easy;
        private JRadioButton medium;
        private JRadioButton hard;
        private JRadioButton custom;
        private JSpinner width;
        private JSpinner height;
        private JSpinner mines;

        SettingsWindow() {
        }

        private Container createContentPane() {
            JPanel contentPane = new JPanel(new BorderLayout());
            contentPane.setOpaque(true);
            contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel center = new JPanel(new GridLayout(1, 2));
            center.setBorder(BorderFactory.createTitledBorder(new BevelBorder(0), "Vaikeus", 2, 2));
            contentPane.add((Component)center, "Center");
            JPanel diffPane = new JPanel(new GridLayout(4, 1));
            ButtonGroup buttons = new ButtonGroup();
            this.easy = new JRadioButton("Helppo");
            this.easy.setMnemonic(72);
            this.easy.setActionCommand("easy");
            this.easy.addActionListener(this);
            buttons.add(this.easy);
            this.medium = new JRadioButton("Medium");
            this.medium.setMnemonic(77);
            this.medium.setActionCommand("medium");
            this.medium.addActionListener(this);
            buttons.add(this.medium);
            this.hard = new JRadioButton("Vaikea");
            this.hard.setMnemonic(86);
            this.hard.setActionCommand("hard");
            this.hard.addActionListener(this);
            buttons.add(this.hard);
            this.custom = new JRadioButton("Mukautettu");
            this.custom.setMnemonic(85);
            this.custom.setActionCommand("custom");
            this.custom.addActionListener(this);
            this.custom.setSelected(true);
            buttons.add(this.custom);
            center.add(diffPane);
            diffPane.add(this.easy);
            diffPane.add(this.medium);
            diffPane.add(this.hard);
            diffPane.add(this.custom);
            JPanel customSettings = new JPanel(new GridLayout(4, 2));
            center.add(customSettings);
            JLabel widthLabel = new JLabel("Leveys");
            widthLabel.setPreferredSize(new Dimension());
            customSettings.add(widthLabel);
            this.width = new JSpinner(new SpinnerNumberModel(2, 2, 50, 1));
            this.width.setEditor(new JSpinner.NumberEditor(this.width, "#"));
            customSettings.add(this.width);
            JLabel heightLabel = new JLabel("Korkeus");
            customSettings.add(heightLabel);
            this.height = new JSpinner(new SpinnerNumberModel(2, 2, 50, 1));
            this.height.setEditor(new JSpinner.NumberEditor(this.height, "#"));
            customSettings.add(this.height);
            JLabel minesLabel = new JLabel("Miinat");
            customSettings.add(minesLabel);
            this.mines = new JSpinner(new SpinnerNumberModel(1, 1, 1250, 1));
            this.mines.setEditor(new JSpinner.NumberEditor(this.mines, "#"));
            customSettings.add(this.mines);
            JPanel bottom = new JPanel(new FlowLayout());
            contentPane.add((Component)bottom, "South");
            JButton ok = new JButton("OK");
            ok.setActionCommand("ok");
            ok.addActionListener(this);
            bottom.add(ok);
            JButton cancel = new JButton("Peruuta");
            cancel.setActionCommand("cancel");
            cancel.addActionListener(this);
            bottom.add(cancel);
            return contentPane;
        }

        public void createSettingsWindow() {
            JDialog settings = new JDialog(this, "Asetukset", true);
            settings.setDefaultCloseOperation(1);
            settings.setContentPane(this.createContentPane());
            settings.pack();
            settings.setLocationRelativeTo(this);
            settings.setResizable(false);
            settings.setVisible(true);
        }

        private void enableCustomSettings(boolean enable) {
            this.width.setEnabled(enable);
            this.height.setEnabled(enable);
            this.mines.setEnabled(enable);
        }

        public void actionPerformed(ActionEvent e) {
            Container window;
            AbstractButton source = (AbstractButton)e.getSource();
            String command = source.getActionCommand();
            if (command.equals("ok")) {
                window = source.getTopLevelAncestor();
                if (this.easy.isSelected()) {
                    HaravaGUI.this.saveSettings(9, 9, 10, 1);
                }
                if (this.medium.isSelected()) {
                    HaravaGUI.this.saveSettings(16, 16, 40, 2);
                }
                if (this.hard.isSelected()) {
                    HaravaGUI.this.saveSettings(22, 22, 100, 3);
                }
                if (this.custom.isSelected()) {
                    int x = Integer.parseInt(this.width.getValue().toString());
                    int y = Integer.parseInt(this.height.getValue().toString());
                    int z = Integer.parseInt(this.mines.getValue().toString());
                    HaravaGUI.this.saveSettings(x, y, z, 0);
                }
                window.setVisible(false);
                HaravaGUI.this.createGameArea();
            }
            if (command.equals("cancel")) {
                window = source.getTopLevelAncestor();
                window.setVisible(false);
            }
            if (command.equals("easy")) {
                this.enableCustomSettings(false);
            }
            if (command.equals("medium")) {
                this.enableCustomSettings(false);
            }
            if (command.equals("hard")) {
                this.enableCustomSettings(false);
            }
            if (command.equals("custom")) {
                this.enableCustomSettings(true);
            }
        }
    }

    class HighScoreWindow
    extends JDialog
    implements ActionListener {
        private HighScoreIO reader = new HighScoreIO();

        HighScoreWindow() {
        }

        private Container createContentPane() {
            this.reader.readValues();
            JPanel contentPane = new JPanel(new BorderLayout());
            contentPane.setOpaque(true);
            contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel scores = new JPanel(new GridLayout(3, 1));
            contentPane.add((Component)scores, "Center");
            JPanel easy = new JPanel(new FlowLayout());
            easy.setBorder(BorderFactory.createTitledBorder(new BevelBorder(0), "Helppo", 2, 2));
            scores.add(easy);
            JLabel name = new JLabel();
            name.setText(this.reader.getName(1));
            name.setPreferredSize(new Dimension(100, 16));
            easy.add(name);
            JLabel time = new JLabel();
            time.setText(this.reader.getTime(1));
            time.setHorizontalAlignment(4);
            time.setPreferredSize(new Dimension(50, 16));
            easy.add(time);
            if (name.getText().equals("Ei l\u00e4p\u00e4isty")) {
                name.setForeground(Color.RED);
                time.setText("");
            }
            JPanel medium = new JPanel(new FlowLayout());
            medium.setBorder(BorderFactory.createTitledBorder(new BevelBorder(0), "Medium", 2, 2));
            scores.add(medium);
            name = new JLabel();
            name.setText(this.reader.getName(2));
            name.setPreferredSize(new Dimension(100, 16));
            medium.add(name);
            time = new JLabel();
            time.setText(this.reader.getTime(2));
            time.setHorizontalAlignment(4);
            time.setPreferredSize(new Dimension(50, 16));
            medium.add(time);
            if (name.getText().equals("Ei l\u00e4p\u00e4isty")) {
                name.setForeground(Color.RED);
                time.setText("");
            }
            JPanel hard = new JPanel(new FlowLayout());
            hard.setBorder(BorderFactory.createTitledBorder(new BevelBorder(0), "Vaikea", 2, 2));
            scores.add(hard);
            name = new JLabel();
            name.setText(this.reader.getName(3));
            name.setPreferredSize(new Dimension(100, 16));
            name.setForeground(Color.RED);
            hard.add(name);
            time = new JLabel();
            time.setText(this.reader.getTime(3));
            time.setHorizontalAlignment(4);
            time.setPreferredSize(new Dimension(50, 16));
            hard.add(time);
            if (name.getText().equals("Ei l\u00e4p\u00e4isty")) {
                name.setForeground(Color.RED);
                time.setText("");
            }
            JPanel bottom = new JPanel(new FlowLayout());
            contentPane.add((Component)bottom, "South");
            JButton ok = new JButton("OK");
            ok.setActionCommand("close");
            ok.addActionListener(this);
            ok.setFocusPainted(false);
            bottom.add(ok);
            return contentPane;
        }

        public void actionPerformed(ActionEvent e) {
            JButton source = (JButton)e.getSource();
            String command = source.getActionCommand();
            if (command.equals("close")) {
                Container window = source.getTopLevelAncestor();
                window.setVisible(false);
            }
        }

        public void createHighScoreWindow() {
            JDialog highscores = new JDialog(this, "Parhaat tulokset", true);
            highscores.setDefaultCloseOperation(1);
            highscores.setContentPane(this.createContentPane());
            highscores.pack();
            highscores.setLocationRelativeTo(this);
            highscores.setResizable(false);
            highscores.setVisible(true);
        }
    }
}

