/*
 * Decompiled with CFR 0.152.
 */
package Miinaharava;

import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class Tile
extends JButton {
    private static final ImageIcon EMPTY = new ImageIcon("images/empty.gif");
    private static final ImageIcon MINE = new ImageIcon("images/mine.gif");
    private static final ImageIcon FLAG = new ImageIcon("images/flag.gif");
    private static final ImageIcon MISS = new ImageIcon("images/miss.gif");
    private static final ImageIcon C1 = new ImageIcon("images/1.gif");
    private static final ImageIcon C2 = new ImageIcon("images/2.gif");
    private static final ImageIcon C3 = new ImageIcon("images/3.gif");
    private static final ImageIcon C4 = new ImageIcon("images/4.gif");
    private static final ImageIcon C5 = new ImageIcon("images/5.gif");
    private static final ImageIcon C6 = new ImageIcon("images/6.gif");
    private static final ImageIcon C7 = new ImageIcon("images/7.gif");
    private static final ImageIcon C8 = new ImageIcon("images/8.gif");
    private final int x;
    private final int y;
    private int adjacentMines;
    private boolean isRevealed;
    private boolean hasMine;
    private boolean hasFlag;

    public Tile(int x, int y) {
        this.setFocusable(false);
        this.setPreferredSize(new Dimension(20, 20));
        this.x = x;
        this.y = y;
        this.adjacentMines = 0;
        this.isRevealed = false;
        this.hasMine = false;
        this.hasFlag = false;
    }

    public int getx() {
        return this.x;
    }

    public int gety() {
        return this.y;
    }

    public int getAdjacentMines() {
        return this.adjacentMines;
    }

    public void setAdjacentMines(int count) {
        this.adjacentMines = count;
    }

    public boolean isMined() {
        return this.hasMine;
    }

    public void setMined(boolean b) {
        this.hasMine = b;
    }

    public boolean isFlagged() {
        return this.hasFlag;
    }

    public void setFlagged(boolean b) {
        this.hasFlag = b;
        if (this.hasFlag) {
            this.showFlag();
        } else {
            this.showNoIcon();
        }
    }

    public boolean isRevealed() {
        return this.isRevealed;
    }

    public void reveal() {
        this.isRevealed = true;
        this.showMinecount();
        this.setEnabled(false);
    }

    public void revealFull() {
        this.isRevealed = true;
        if (this.isFlagged() && !this.isMined()) {
            this.showMiss();
        } else if (!this.isFlagged() && this.isMined()) {
            this.showMine();
        } else if (this.isFlagged() && this.isMined()) {
            this.showFlag();
        }
        this.setEnabled(false);
    }

    private void showNoIcon() {
        this.setIcon(EMPTY);
        this.setDisabledIcon(EMPTY);
    }

    private void showMine() {
        this.setIcon(MINE);
        this.setDisabledIcon(MINE);
    }

    private void showFlag() {
        this.setIcon(FLAG);
        this.setDisabledIcon(FLAG);
    }

    private void showMiss() {
        this.setIcon(MISS);
        this.setDisabledIcon(MISS);
    }

    private void showMinecount() {
        switch (this.adjacentMines) {
            case 0: {
                this.setIcon(EMPTY);
                this.setDisabledIcon(EMPTY);
                break;
            }
            case 1: {
                this.setIcon(C1);
                this.setDisabledIcon(C1);
                break;
            }
            case 2: {
                this.setIcon(C2);
                this.setDisabledIcon(C2);
                break;
            }
            case 3: {
                this.setIcon(C3);
                this.setDisabledIcon(C3);
                break;
            }
            case 4: {
                this.setIcon(C4);
                this.setDisabledIcon(C4);
                break;
            }
            case 5: {
                this.setIcon(C5);
                this.setDisabledIcon(C5);
                break;
            }
            case 6: {
                this.setIcon(C6);
                this.setDisabledIcon(C6);
                break;
            }
            case 7: {
                this.setIcon(C7);
                this.setDisabledIcon(C7);
                break;
            }
            case 8: {
                this.setIcon(C8);
                this.setDisabledIcon(C8);
                break;
            }
            default: {
                this.setIcon(EMPTY);
                this.setDisabledIcon(EMPTY);
            }
        }
    }
}

