/**
 * Copyright (c) 2011, Leena Salmela <leena.salmela@cs.helsinki.fi>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef ALIGN_H
#define ALIGN_H

#define MAX_CONTIG_LEN 5000000

#define MAX_ERR 0.1

typedef struct {
    int score;
    int match;
    int len1;
    int len2;
} entry_t;

typedef struct {
    char buf1[MAX_CONTIG_LEN];
    char buf2[MAX_CONTIG_LEN];

    entry_t dp[2][MAX_CONTIG_LEN];
} align_t;

align_t *init_align();

void reverse_base(char *orig, char *reversed);

int is_contained(char *contig1, int forward1, int len1,
                 char *contig2, int forward2, int len2,
                 int start, int end, align_t *align, double max_err);

int is_overlap(char *contig1, int forward1, int len1,
               char *contig2, int forward2, int len2,
               int start, int end, align_t *align, double max_err);

#endif
