#!/usr/bin/perl
# Copyright (c) 2011, Leena Salmela <leena.salmela@cs.helsinki.fi>
# All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
# IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

if ($#ARGV +1 != 3) {
    die "Usage: merge-mapping-lines.pl <f3-mappings> <r3-mappings> <merged mappings>";
}

$mate1 = shift;
$mate2 = shift;
$merged = shift;

%mappings1;

open(OF, $mate1) or die "Could not open first mapping file\n";

while(<OF>) {
    chomp;
    $line = $_;
    if ($line =~ /(.*)F3\t(.*)/) {
        $name = $1;
        if ($line =~ /^[^\t]*\t[^\t]*\t([^\t]*)\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*/) {
            if ($1 ne "*") {
                if ($line =~ /^([^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*)/) {
                    $mappings1{$name} = $1;
                }
            }
        } else {
            die "Invalid line in SAM file: $line\n";
        }
    }
}

close(OF);

#%mapping2;

open(OF, $mate2) or die "Could not open second mapping file\n";
open(M, ">$merged") or die "Could not open merged file\n";

while(<OF>) {
    chomp;
    $line = $_;
    if ($line =~ /(.*)R3\t(.*)/) {
        $name = $1;
        if ($line =~ /^[^\t]*\t[^\t]*\t([^\t]*)\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*/) {
            if ($1 ne "*") {
                if ($line =~ /^([^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*\t[^\t]*)/) {
                    #           $mappings2{$name} = $1;
                    if ($mappings1{$name}) {
                        print M $mappings1{$name} . "\t" . $1 . "\n";
                    } else {
#                print L1 $mappings1{$key} . "\n";
                    }
                }
            }
        } else {
            die "Invalid line in SAM file: $line\n";
        }
    }
}

close(OF);

#open(L1, ">$mate1.single") or die "Could not open first single file\n";
#open(L2, ">$mate2.single") or die "Could not open second single file\n";

#open(M, ">$merged") or die "Could not open merged file\n";

#foreach $key (keys %mappings1) {
#    if ($mappings2{$key}) {
#        print M $mappings1{$key} . "\t" . $mappings2{$key} . "\n";
#    } else {
#        print L1 $mappings1{$key} . "\n";
#    }
#}

#foreach $key (keys %mappings2) {
#    if (!($mappings1{$key})) {
#        print L2 $mappings2{$key} . "\n";
#    }
#}

#close(L1);
#close(L2);
close(M);
