#!/usr/bin/perl
# Copyright (c) 2011, Leena Salmela <leena.salmela@cs.helsinki.fi>
# All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
# IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.


if ($#ARGV +1 != 2) {
    die "Usage: translate_depth.pl <previous depth file> <contig positions>";
}

%len;
%depth;

$depth=shift;
$scaffold2=shift;

open(DF, $depth) or die "Could not open depth file\n";

while(<DF>) {
    $line = $_;
    if ($line =~ /(\d+)\s+(.+)\s+(\d+)\s+(.+)/) {
        $depth{$2} = $4;
        $len{$2} = $3;
    } else {
        die "Invalid line in depth file\n";
    }
}

close(DF);

open(SF, $scaffold2);

$i=0;
$d= 0.0;
$scaf= "";
$l = 0;

while(<SF>) {
    chomp;
    $line = $_;
    if ($line =~ /^scaffold/) {
        if ($i > 0) {
            print $i . "\t" . $scaf . "\t" . $ml . "\t" . ($d/$l) . "\n";
        }
        $i++;
        $scaf = $line;
        $l = 0;
        $d = 0;
        $ml = 0;
    } elsif ($line =~ /^contig/) {
        if ($line =~ /contig\s+(.+)\s+(.+)\s+(\d+)\s+(\d+)/) {

            $l += $len{$1};
            $d += $len{$1}*$depth{$1};
            if ($ml < $4) {
                $ml = $4;
            }
        } else {
            print $line;
            die "Invalid line in contig placement file\n";
        }
    } else {
        print $line;
        die "Invalid line in contig placement file\n";
    }
}

if ($i > 0) {
    print $i . "\t" . $scaf . "\t" . $ml . "\t" . ($d/$l) . "\n";
}

close(SF);
