#!/usr/bin/perl
# Copyright (c) 2011, Leena Salmela <leena.salmela@cs.helsinki.fi>
# All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
# IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

if ($#ARGV +1 != 2) {
    die "Usage: translate_mappings.pl <previous mappings> <contig positions>";
}

%scaf;
%ori;
%start;
%end;

$mappings = shift;
$scaffolds2 = shift;

open(SF, $scaffolds2) or die "Could not open contig placement file\n";

while(<SF>) {
    chomp;
    $line = $_;
    if ($line =~ /^scaffold/) {
        $cur_scaf = $line;
    } elsif ($line =~ /^contig/) {
        if ($line =~ /contig\s+(.+)\s+(.+)\s+(\d+)\s+(\d+)/) {
            $scaf{$1} = $cur_scaf;
            $ori{$1} = $2;
            $start{$1} = $3;
            $end{$1} = $4;
        } else {
            die "Invalid line in contig placement file\n";
        }
    } else {
        die "Invalid line in contig placement file\n";
    }
}

close(SF);

open(MF, $mappings) or die "Could not open mapping file\n";

while(<MF>) {
    chomp;
    $line = $_;
    @tokens = split(/\s+/, $line);
    $name1 = $tokens[2];
    $name2 = $tokens[13];
    $tokens[2] = $scaf{$name1};
    $tokens[13] = $scaf{$name2};
    if (!($name1 eq $name2)) {
        if ($ori{$name1} eq "F") {
            $tokens[3] = $start{$name1} + $tokens[3];
        } elsif ($ori{$name1} eq "R") {
            $len = 0;
            @cigar = split(/[MIDSH]/, $tokens[5]);
            foreach (@cigar) {
                $len += $_;
            }
            $tokens[3] = $end{$name1} -$tokens[3] - $len;
            if (($tokens[1] & 16) == 16) {
                $tokens[1] = (~16) & $tokens[1];
            } else {
                $tokens[1] = 16 | $tokens[1];
            }
        } else {
            print $ori{$name1} . "\n";
            die "Could not find orientation for " . $name1 . "\n";
        }
        if ($ori{$name2} eq "F") {
            $tokens[14] = $start{$name2} + $tokens[14];
        } elsif ($ori{$name2} eq "R") {
            $len = 0;
            @cigar = split(/[MIDSH]/, $tokens[16]);
            foreach (@cigar) {
                $len += $_;
            }
            $tokens[14] = $end{$name2} -$tokens[14] - $len;
            if (($tokens[12] & 16) == 16) {
                $tokens[12] = (~16) & $tokens[12];
            } else {
                $tokens[12] = 16 | $tokens[12];
            }
        } else {
            print $ori{$name2} . "\n";
            die "Could not find orientation for " . $name2 . "\n";
        }

        print $tokens[0];
        for($i = 1; $i < 22; $i++) {
            print "\t" . $tokens[$i];
        }
        print "\n";
    }
}

close(MF);
