/****************************************************************** 
* PROGRAM: Implementation of disjoint-set forests with union by * 
* rank and path compression heuristics. Operations take * 
* practically constant time. Implements CLRS Chap 21.3 * 
* AUTHOR: Bo Tian (bt288 at cam.ac.uk) drop me an email if you * 
* have any questions. * 
* LICENSE: Creative Commons Attribution 3.0 Unported * 
* http://creativecommons.org/licenses/by/3.0/ * 
*******************************************************************/ 
#ifndef DISJOINT_SET_H
#define DISJOINT_SET_H

#include <iostream> 
using namespace std; 

template<class T> class DisjointSetForest { 
private: 
	struct node { 
		T val; 
		node *parent; 
		long rank; 
	}; 
	 
public: 
	DisjointSetForest() {} 
	long makeset (T a); 
	long find (long a); 
	void Union (long s1, long s2); 
        T getvalue(long);
        long getrank(long);
}; 

 
template<class T> long DisjointSetForest<T>::makeset(T a) { 
	node *makeNode = new node; 
	makeNode->val = a; 
	makeNode->parent = makeNode; 
	makeNode->rank = 0; 
	return (long) makeNode; 
} 
 
template<class T> long DisjointSetForest<T>::find (long a) { 
	node *tmp = (node*) a; 
	if (tmp != tmp->parent) 
		return find((long) tmp->parent); 
	else 
		return a; 
} 
 
template<class T> void DisjointSetForest<T>::Union (long s1, long s2) { 
	node *t1 = (node*) s1; 
	node *t2 = (node*) s2; 
	if (t1->rank > t2->rank) 
		t2->parent = t1; 
	else { 
		t1->parent = t2; 
		if (t1->rank == t2->rank) 
			(t2->rank)++; 
	} 
} 

template<class T> T DisjointSetForest<T>::getvalue(long a) { 
    node *n = (node *)a;
    return n->val;
}

template<class T> long DisjointSetForest<T>::getrank(long a) { 
    node *n = (node *)a;
    return n->rank;
}
#endif
