/**
 * Copyright (c) 2011, Leena Salmela <leena.salmela@cs.helsinki.fi>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef GRAPH_H
#define GRAPH_H

#include <lemon/concepts/graph.h>
#include <lemon/list_graph.h>

#include <map>

using namespace std;

extern lemon::ListGraph G;
extern map<int,lemon::ListGraph::Node> nodes;
extern lemon::ListGraph::NodeMap<int> node2id;
extern lemon::ListGraph::NodeMap<int> node2contig;
extern lemon::ListGraph::EdgeMap<int> support;
extern lemon::ListGraph::EdgeMap<int> avg_dist;
extern lemon::ListGraph::EdgeMap<int> min_dist;
extern lemon::ListGraph::EdgeMap<int> max_dist;
extern lemon::ListGraph::EdgeMap<int> min_span1;
extern lemon::ListGraph::EdgeMap<int> max_span1;
extern lemon::ListGraph::EdgeMap<int> min_span2;
extern lemon::ListGraph::EdgeMap<int> max_span2;

extern lemon::ListGraph cG;
extern map<int,lemon::ListGraph::Node> cnodes;
extern lemon::ListGraph::NodeMap<int> cnode2contig;
extern lemon::ListGraph::NodeMap<int> component;
extern lemon::ListGraph::NodeMap<int> parent;

extern map<int,lemon::ListGraph::Node> component_root;

extern map<int,int> label_map;

lemon::ListGraph::Edge get_edge(lemon::ListGraph::Node node1,
                                lemon::ListGraph::Node node2);

int degree_histogram(int **degrees);

void fix_impossible_edges();

void remove_negative_edges(char **contigs, int *contig_len, int min_support,
                           int check, double max_align_err);

void disconnect_high_degree_nodes(int degree_limit);

map<long,list<long> * > *remove_low_support_links(double *contig_depth, int *contig_length, int min_support, int max_block_size, double depth_limit, int length_limit);

#endif
