/**
 * Copyright (c) 2011, Leena Salmela <leena.salmela@cs.helsinki.fi>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#include <set>
#include <map>
#include <iostream>
#include <fstream>

#include <stdlib.h>
#include <stdio.h>
#include <dirent.h>
#include <string.h>
#include <limits.h>

using namespace std;

#include "io.h"
#include "align.h"

void usage(char *prog) {
  printf("Usage: %s [options] <contigs> <contig pos> <scaffold fasta> <scaffolds exact pos>\n\n", prog);

  printf("Options:\n");
  printf("-e <float>    Maximum error allowed when aligning contigs\n");
}

int main(int argc, char *argv[]) {
  int *contig_length;
  char **contig_seq;
  char **contig_names;
  map<string,int> contig2id;
  double max_align_err = -1.0;
  char *prog = argv[0];

  while(argc > 4) {
    if (!strcmp(argv[0], "-e")) {
      max_align_err = atof(argv[1]);
      argv++;
      argc--;
    }
    argc--;
    argv++;
  }

  if (argc != 4) {
    usage(prog);
    abort();
  }

  read_contigs(argv[0], &contig_length, &contig_seq, &contig_names, &contig2id);

  printf("Read contigs\n");

  translate_scaffolds(argv[1], argv[2], argv[3], contig_length, contig_seq, 
                      contig_names, &contig2id, max_align_err);

  return 0;
}
