/*
 * Copyright (C) 2002  Pekka Enberg <Pekka.Enberg@cs.helsinki.fi>
 *
 * Distributed under the terms of the GNU General Public License
 * version 2 or later.
 */
#ifndef _BUFFER_H_
#define _BUFFER_H_ 1

#include <stdbool.h>
#include <stdio.h>
#include <stddef.h>

/* Buffer used to hold XML stream.  */
struct buffer {
    char * data;
    size_t length;
    size_t capacity;
};

void buffer_init(struct buffer * buffer, size_t initial_capacity);
void buffer_release(struct buffer * buffer);
void buffer_push_str(struct buffer * buffer, const char * text);
void buffer_push_char(struct buffer * buffer, int c);
int buffer_pop_char(struct buffer * buffer);
void buffer_flush(struct buffer * buffer, FILE * output);
void buffer_copy(struct buffer * dest, struct buffer * src);
void buffer_clear(struct buffer * buf);
size_t buffer_size(struct buffer * buffer);

#endif
