/*
 * Copyright (C) 2002-2003  Pekka Enberg <penberg@iki.fi>
 *
 * Distributed under the terms of the GNU General Public License
 * version 2 or later.
 */

/* Scanner for XML Indent.  */

%{
/* Flex 2.5.31 and higher limits use of unput() to definitions section
   of the input file.  */ 

static void yyunput(int, char *);

void do_unput(int c)
{
    unput(c);
}
%}

/* We don't mind formatting non-valid XML so the pattern tokens do not
   have to be 100% compiliant to the specification.  */

XML_DECLARATION		"<?xml".*"?>"
DOCTYPE_DECLARATION	"<!DOCTYPE"[^>]*">"
CDATA_SECTION		"<![CDATA["([^\]]*|\][^\]]|\]\][^>])*"]]>"

/*
 * We're sort of following Section 3.1. of XML 1.0 spec [1] here.
 *
 * 1. http://www.w3.org/TR/2000/REC-xml-20001006
 */

LETTER			[[:alpha:]]
DIGIT			[[:digit:]]
NAME_CHAR		({LETTER}|{DIGIT}|\.|-|_|:)
NAME			({LETTER}|_|:)({NAME_CHAR})*
SPACE			([[:space:]]|\n)
ENTITY_REF		(\&{NAME};)
CHAR_REF		((\&#[0-9]+;)|(\&#x[0-9a-fA-F]+;))
REFERENCE		({ENTITY_REF}|{CHAR_REF})
ATT_VALUE		((\"([^<\&\"]|{REFERENCE})*\")|(\'([^<\&\']|{REFERENCE})*\'))
ATTRIBUTE		{NAME}{SPACE}*"="{SPACE}*{ATT_VALUE}
START_TAG		"<"{NAME}({SPACE}*{ATTRIBUTE})*{SPACE}*">"
END_TAG			"</"{NAME}{SPACE}*">"
EMPTY_ELEMENT_TAG	"<"{NAME}({SPACE}*{ATTRIBUTE})*{SPACE}*"/>"
CONTENT			[^\<]
COMMENT			"<!--"

%%

{XML_DECLARATION} {
	xml_declaration();
}

{CDATA_SECTION} {
	cdata_section();
}

{DOCTYPE_DECLARATION} {
	doctype_declaration();
}

{START_TAG} {
	start_tag();
}

{END_TAG} {
	end_tag();
}

{EMPTY_ELEMENT_TAG} {
	empty_element_tag();
}

{CONTENT} {
	content();
}

{COMMENT} {
	comment();
}

%%
