/*
 * Copyright (C) 2002-2003  Pekka Enberg <penberg@iki.fi>
 *
 * Distributed under the terms of the GNU General Public License
 * version 2 or later.
 */
#ifndef _INDENT_H_
#define _INDENT_H_ 1

#include "buffer.h"
#include <stdbool.h>

/*
 * Indent options
 */
struct indent_options {
    char indent_char;
    int  num_indent_chars;
    bool force_newline_after_start_tag;
    bool force_newline_after_end_tag;
    bool force_newline_before_start_tag;
    bool force_newline_before_end_tag;
    int  max_columns;
    bool wrap_long_lines;
};

void indent_options_set_defaults(struct indent_options * opts);
void indent(FILE * input, FILE * output, struct indent_options * opts);

#endif
