/*
 * Copyright (C) 2002  Pekka Enberg <Pekka.Enberg@cs.helsinki.fi>
 *
 * Distributed under the terms of the GNU General Public License
 * version 2 or later.
 */

/* Scanner for XML Indent.  */

/* We don't mind formatting non-valid XML so the pattern tokens do not
   have to be 100% compiliant to the specification.  */

XML_DECLARATION		"<?xml".*"?>"
DOCTYPE_DECLARATION	"<!DOCTYPE"[^>]*">"
CDATA_SECTION		"<![CDATA["(.|\n)*"]]>"

START_TAG		"<"([[:alpha:]]|_|:)[^/>]*">"
END_TAG			"</"([[:alpha:]]|_|:)[^>]*">"
EMPTY_ELEMENT_TAG	"<"([[:alpha:]]|_|:)[^>]*"/>"
COMMENT			"<!--"
NEWLINE			\n

%%

{XML_DECLARATION} {
	xml_declaration(buffer, yytext);
}

{CDATA_SECTION} {
	cdata_section(buffer, yytext);
}

{DOCTYPE_DECLARATION} {
	doctype_declaration(buffer, yytext);
}

{START_TAG} {
	start_tag(buffer, yytext);
}

{END_TAG} {
	end_tag(buffer, yytext);
}

{EMPTY_ELEMENT_TAG} {
	empty_element_tag(buffer, yytext);
}

{COMMENT} {
	comment(buffer, yytext);
}

{NEWLINE} {
	newline(buffer, yytext);
}

. {
	character_text(buffer, yytext);
}

%%
